/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import springfox.documentation.PathProvider;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanResult;
import springfox.documentation.spring.web.scanners.PathMappingAdjuster;

@Component
public class ApiListingReferenceScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ApiListingReferenceScanner.class);

    public ApiListingReferenceScanResult scan(DocumentationContext context) {
        LOG.info("Scanning for api listing references");
        ArrayList apiListingReferences = Lists.newArrayList();
        ArrayListMultimap resourceGroupRequestMappings = ArrayListMultimap.create();
        HashMap<ResourceGroup, String> resourceGroupDescriptions = new HashMap<ResourceGroup, String>();
        ApiSelector selector = context.getApiSelector();
        for (RequestMappingHandlerMapping requestMappingHandlerMapping : context.getHandlerMappings()) {
            for (RequestHandler handler : this.matchingHandlers(requestMappingHandlerMapping, selector)) {
                RequestMappingInfo requestMappingInfo = handler.getRequestMapping();
                HandlerMethod handlerMethod = handler.getHandlerMethod();
                ResourceGroupingStrategy resourceGroupingStrategy = context.getResourceGroupingStrategy();
                Set resourceGroups = resourceGroupingStrategy.getResourceGroups(requestMappingInfo, handlerMethod);
                String handlerMethodName = handlerMethod.getMethod().getName();
                String resourceDescription = resourceGroupingStrategy.getResourceDescription(requestMappingInfo, handlerMethod);
                RequestMappingContext requestMappingContext = new RequestMappingContext(context, requestMappingInfo, handlerMethod);
                LOG.info("Request mapping: {} belongs to groups: [{}] ", (Object)handlerMethodName, (Object)resourceGroups);
                for (ResourceGroup group : resourceGroups) {
                    resourceGroupDescriptions.put(group, resourceDescription);
                    LOG.info("Adding resource to group:{} with description:{} for handler method:{}", new Object[]{group, resourceDescription, handlerMethodName});
                    resourceGroupRequestMappings.put((Object)group, (Object)requestMappingContext);
                }
            }
        }
        for (ResourceGroup resourceGroup : resourceGroupDescriptions.keySet()) {
            String resourceGroupName = resourceGroup.getGroupName();
            String listingDescription = (String)resourceGroupDescriptions.get(resourceGroup);
            Integer position = resourceGroup.getPosition();
            PathProvider pathProvider = context.getPathProvider();
            String path = pathProvider.getResourceListingPath(context.getGroupName(), resourceGroupName);
            LOG.info("Created resource listing Path: {} Description: {} Position: {}", new Object[]{path, resourceGroupName, position});
            PathMappingAdjuster adjuster = new PathMappingAdjuster(context);
            apiListingReferences.add(new ApiListingReference(adjuster.adjustedPath(path), listingDescription, position.intValue()));
        }
        List sorted = context.getListingReferenceOrdering().sortedCopy((Iterable)apiListingReferences);
        return new ApiListingReferenceScanResult(sorted, Multimaps.asMap((ListMultimap)resourceGroupRequestMappings));
    }

    private Set<RequestHandler> matchingHandlers(RequestMappingHandlerMapping requestMappingHandlerMapping, ApiSelector selector) {
        return FluentIterable.from(requestMappingHandlerMapping.getHandlerMethods().entrySet()).transform(this.toRequestHandler()).filter(selector.getRequestHandlerSelector()).toSet();
    }

    private Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler> toRequestHandler() {
        return new Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler>(){

            public RequestHandler apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return new RequestHandler(input.getKey(), input.getValue());
            }
        };
    }
}

