/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import rawhttp.core.EagerHttpResponse;
import rawhttp.core.RawHttp;
import rawhttp.core.RawHttpResponse;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Header;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147482648)
public class SpringRestDocsOperationBuilderPlugin
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SpringRestDocsOperationBuilderPlugin.class);

    public void apply(OperationContext context) {
        context.operationBuilder().responseMessages(this.read(context));
    }

    public boolean supports(DocumentationType documentationType) {
        return DocumentationType.SWAGGER_12.equals((Object)documentationType) || DocumentationType.SWAGGER_2.equals((Object)documentationType);
    }

    protected Set<ResponseMessage> read(OperationContext context) {
        Set ret;
        try {
            PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resourceResolver.getResources("classpath*:" + context.getName() + "*/http-response.springfox");
            ret = Arrays.stream(resources).map(this.toRawHttpResponse()).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toMap(RawHttpResponse::getStatusCode, this.mappingResponseToResponseMessageBuilder(), this.mergingExamples()), responseMessagesMap -> responseMessagesMap.values().stream().map(ResponseMessageBuilder::build).collect(Collectors.toSet())));
        }
        catch (Exception e) {
            LOG.warn("Failed to read restdocs example for {} " + context.getName() + " caused by: " + e.toString());
            ret = Collections.emptySet();
        }
        return ret;
    }

    private Function<Resource, RawHttpResponse<Void>> toRawHttpResponse() {
        return resource -> {
            try (InputStream resourceAsStream = resource.getInputStream();){
                RawHttp rawHttp = new RawHttp();
                EagerHttpResponse eagerHttpResponse = rawHttp.parseResponse(resourceAsStream).eagerly();
                return eagerHttpResponse;
            }
            catch (IOException e) {
                LOG.warn("Failed to read restdocs example for {} " + resource.getFilename() + " caused by: " + e.toString());
                return null;
            }
        };
    }

    private BinaryOperator<ResponseMessageBuilder> mergingExamples() {
        return (leftWithSameStatusCode, rightWithSameStatusCode) -> leftWithSameStatusCode.examples(rightWithSameStatusCode.build().getExamples());
    }

    private Function<RawHttpResponse<Void>, ResponseMessageBuilder> mappingResponseToResponseMessageBuilder() {
        return parsedResponse -> new ResponseMessageBuilder().code(parsedResponse.getStatusCode()).examples(this.toExamples((RawHttpResponse<Void>)parsedResponse)).headersWithDescription(this.toHeaders((RawHttpResponse<Void>)parsedResponse));
    }

    private Map<String, Header> toHeaders(RawHttpResponse<Void> parsedResponse) {
        return parsedResponse.getHeaders().asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> new Header((String)o.getKey(), "", (ModelReference)new ModelRef("string"))));
    }

    private List<Example> toExamples(RawHttpResponse<Void> parsedResponse) {
        return Collections.singletonList(new Example(this.getContentType(parsedResponse), (Object)this.getBody(parsedResponse)));
    }

    private String getBody(RawHttpResponse<Void> parsedResponse) {
        return parsedResponse.getBody().map(bodyReader -> {
            String ret = null;
            try {
                ret = bodyReader.asRawString(Charset.forName("utf-8"));
            }
            catch (IOException e) {
                LOG.error("failed to read response body", (Throwable)e);
            }
            return ret;
        }).orElse(null);
    }

    private String getContentType(RawHttpResponse<Void> parsedResponse) {
        return parsedResponse.getHeaders().get("Content-Type").stream().findFirst().orElse(null);
    }
}

