/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property.provider;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.property.bean.BeanModelPropertyProvider;
import springfox.documentation.schema.property.constructor.ConstructorModelPropertyProvider;
import springfox.documentation.schema.property.field.FieldModelPropertyProvider;
import springfox.documentation.schema.property.provider.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component(value="default")
public class DefaultModelPropertiesProvider
implements ModelPropertiesProvider,
ApplicationListener<ObjectMapperConfigured> {
    private final FieldModelPropertyProvider fieldModelPropertyProvider;
    private final BeanModelPropertyProvider beanModelPropertyProvider;
    private final ConstructorModelPropertyProvider constructorModelPropertyProvider;

    @Autowired
    public DefaultModelPropertiesProvider(BeanModelPropertyProvider beanModelPropertyProvider, FieldModelPropertyProvider fieldModelPropertyProvider, ConstructorModelPropertyProvider constructorModelPropertyProvider) {
        this.beanModelPropertyProvider = beanModelPropertyProvider;
        this.fieldModelPropertyProvider = fieldModelPropertyProvider;
        this.constructorModelPropertyProvider = constructorModelPropertyProvider;
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        return FluentIterable.from((Iterable)Iterables.concat(this.fieldModelPropertyProvider.propertiesFor(type, givenContext), this.beanModelPropertyProvider.propertiesFor(type, givenContext), this.constructorModelPropertyProvider.propertiesFor(type, givenContext))).filter(this.visibleProperties()).toList();
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
    }

    private Predicate<ModelProperty> visibleProperties() {
        return new Predicate<ModelProperty>(){

            public boolean apply(ModelProperty input) {
                return !input.isHidden();
            }
        };
    }
}

