/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuilderDefaults {
    private BuilderDefaults() {
        throw new UnsupportedOperationException();
    }

    public static <T> T defaultIfAbsent(T newValue, T defaultValue) {
        return (T)Optional.fromNullable(newValue).or(Optional.fromNullable(defaultValue)).orNull();
    }

    public static <T> List<T> nullToEmptyList(List<T> newValue) {
        if (newValue == null) {
            return Lists.newArrayList();
        }
        return newValue;
    }

    public static <K, V> Map<K, V> nullToEmptyMap(Map<K, V> newValue) {
        if (newValue == null) {
            return Maps.newHashMap();
        }
        return newValue;
    }

    public static <T> Set<T> nullToEmptySet(Set<T> newValue) {
        if (newValue == null) {
            return Sets.newHashSet();
        }
        return newValue;
    }

    public static ResolvedType replaceIfMoreSpecific(ResolvedType replacement, ResolvedType defaultValue) {
        if (BuilderDefaults.isObject(replacement = BuilderDefaults.defaultIfAbsent(replacement, defaultValue)) && BuilderDefaults.isNotObject(defaultValue)) {
            return defaultValue;
        }
        return replacement;
    }

    private static boolean isNotObject(ResolvedType defaultValue) {
        return defaultValue != null && !Object.class.equals((Object)defaultValue.getErasedType());
    }

    private static boolean isObject(ResolvedType replacement) {
        return replacement != null && Object.class.equals((Object)replacement.getErasedType());
    }
}

