package io.split.qos.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class StateDTO {
    @JsonProperty
    private Status status;

    @JsonProperty
    private String who;

    @JsonProperty
    private Long since;

    @JsonProperty
    private Long lastTestFinished;

    public static StateDTO paused(String who, Long since, Long lastTestFinished) {
        return new StateDTO(Status.PAUSED, who, since, lastTestFinished);
    }

    public static StateDTO active(String who, Long since, Long lastTestFinished) {
        return new StateDTO(Status.ACTIVE, who, since, lastTestFinished);
    }

    public StateDTO() { }

    private StateDTO(Status status, String who, Long since, Long lastTestFinished) {
        this.status = Preconditions.checkNotNull(status);
        this.who = Preconditions.checkNotNull(who);
        this.since = Preconditions.checkNotNull(since);
        this.lastTestFinished = lastTestFinished;
    }

    public Status status() {
        return status;
    }

    public String who() {
        return who;
    }

    public Long since() {
        return since;
    }

    public Long lastTestFinished() {
        return lastTestFinished;
    }
}
