package io.split.qos.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class RegisterDTO {

    @JsonProperty
    private String serverName;

    @JsonProperty
    private  String serverURL;

    @JsonProperty
    private String botName;

    public RegisterDTO() { }

    public RegisterDTO(String serverName, String serverURL, String botName) {
        this.serverName = Preconditions.checkNotNull(serverName);
        this.serverURL = Preconditions.checkNotNull(serverURL);
        this.botName = Preconditions.checkNotNull(botName);
    }

    public String serverName() {
        return serverName;
    }

    public String serverURL() {
        return serverURL;
    }

    public String botName() {
        return botName;
    }

    @Override
    public String toString() {
        return String.format("{serverName: %s, serverURL: %s, botName: %s}", serverName, serverURL, botName);
    }
}