package io.split.qos.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import java.util.List;

public class GreenDTO {

    @JsonProperty
    private Status status;

    @JsonProperty
    private Long when;

    @JsonProperty
    private List<String> failed;

    public static GreenDTO green(Long when) {
        return new GreenDTO(Status.GREEN, Preconditions.checkNotNull(when), Lists.newArrayList());
    }

    public static GreenDTO waiting() {
        return new GreenDTO(Status.WAITING_CYCLE, null, Lists.newArrayList());
    }

    public static GreenDTO failed(List<String> failed) {
        return new GreenDTO(Status.RED, null, Preconditions.checkNotNull(failed));
    }

    public GreenDTO() { }

    private GreenDTO(Status status, Long when, List<String> failed) {
        this.status = Preconditions.checkNotNull(status);
        this.failed = Preconditions.checkNotNull(failed);
        this.when = when;
    }

    public Status status() {
        return status;
    }

    public Long when() {
        return when;
    }

    public List<String> failed() {
        return failed;
    }

    public enum Status {
        GREEN,
        WAITING_CYCLE,
        RED,
        ;
    }

    @Override
    public String toString() {
        return String.format("{status: %s, when: %s, failed: [%s]}", status, when, String.join(",", failed));
    }
}
