package io.split.qos.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class CountDTO {
    @JsonProperty
    private Integer succeeded;

    @JsonProperty
    private Integer missing;

    @JsonProperty
    private Integer failed;

    @JsonProperty
    private Integer total;

    public static CountDTO get(Integer succeeded, Integer missing, Integer failed) {
        return new CountDTO(succeeded, missing, failed);
    }

    public CountDTO() { }

    private CountDTO(Integer succeeded, Integer missing, Integer failed) {
        this.succeeded = Preconditions.checkNotNull(succeeded);
        this.missing = Preconditions.checkNotNull(missing);
        this.failed = Preconditions.checkNotNull(failed);
        this.total = succeeded + missing + failed;
    }

    public Integer succeeded() {
        return succeeded;
    }

    public Integer failed() {
        return failed;
    }

    public Integer missing() {
        return missing;
    }

    public Integer total() {
        return total;
    }
}
