/*
 * Decompiled with CFR 0.152.
 */
package io.split.fastly.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Response;
import io.split.fastly.client.VersionResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class FastlyApiClient {
    static final String FASTLY_URL = "https://api.fastly.com";
    static final Joiner SURROGATE_KEY_JOINER = Joiner.on((String)" ");
    private final Map<String, String> _commonHeaders;
    private final AsyncHttpClientConfig _config;
    private final AsyncHttpExecutor _asyncHttpExecutor;
    private final String _serviceId;
    private final String _apiKey;

    public FastlyApiClient(String apiKey, String serviceId) {
        this(apiKey, serviceId, null);
    }

    public FastlyApiClient(String apiKey, String serviceId, AsyncHttpClientConfig config) {
        this(apiKey, serviceId, config, null);
    }

    @VisibleForTesting
    FastlyApiClient(String apiKey, String serviceId, AsyncHttpClientConfig config, AsyncHttpExecutor executor) {
        this._commonHeaders = ImmutableMap.of((Object)"Fastly-Key", (Object)apiKey, (Object)"Accept", (Object)"application/json", (Object)"User-Agent", (Object)("fastly-api-java-v" + VersionResolver.instance().getVersion()));
        this._config = config;
        this._apiKey = apiKey;
        this._serviceId = serviceId;
        this._asyncHttpExecutor = Objects.isNull(executor) ? new AsyncHttpExecutorImpl() : executor;
    }

    public Future<Response> vclUpload(int version, String vcl, String id, String name) {
        return this.vclUpload(version, vcl, id, name, FASTLY_URL);
    }

    public Future<Response> vclUpload(int version, String vcl, String id, String name, String fastlyUrl) {
        String apiUrl = String.format("%s/service/%s/version/%d/vcl", fastlyUrl, this._serviceId, version);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).put((Object)"Content-Type", (Object)"application/x-www-form-urlencoded").build(), (Map<String, String>)ImmutableMap.builder().put((Object)"content", (Object)vcl).put((Object)"name", (Object)name).put((Object)"id", (Object)id).build());
    }

    public List<Future<Response>> vclUpdate(int version, Map<String, String> vcl) {
        return this.vclUpdate(version, vcl, FASTLY_URL);
    }

    public List<Future<Response>> vclUpdate(int version, Map<String, String> vcl, String fastlyUrl) {
        return vcl.entrySet().stream().map(e -> {
            String apiUrl = String.format("%s/service/%s/version/$d/vcl/%s", fastlyUrl, this._serviceId, version, e.getKey());
            return this._asyncHttpExecutor.execute(apiUrl, Method.PUT, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).put((Object)"Content-Type", (Object)"application/x-www-form-urlencoded").build(), (Map<String, String>)ImmutableMap.builder().put((Object)"content", (Object)((String)e.getValue())).put((Object)"name", (Object)((String)e.getKey())).build());
        }).collect(Collectors.toList());
    }

    public Future<Response> purgeUrl(String url) {
        return this.purgeUrl(url, Collections.emptyMap());
    }

    public Future<Response> softPurgeUrl(String url) {
        return this.softPurgeUrl(url, Collections.emptyMap());
    }

    public Future<Response> softPurgeUrl(String url, Map<String, String> extraHeaders) {
        return this.purgeUrl(url, this.buildHeaderForSoftPurge(extraHeaders));
    }

    public Future<Response> purgeUrl(String url, Map<String, String> extraHeaders) {
        return this._asyncHttpExecutor.execute(url, Method.PURGE, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).putAll(extraHeaders).build(), Collections.emptyMap());
    }

    public Future<Response> purgeKey(String key) {
        return this.purgeKey(key, Collections.emptyMap());
    }

    public Future<Response> softPurgeKey(String key) {
        return this.softPurgeKey(key, Collections.emptyMap());
    }

    public Future<Response> softPurgeKey(String key, Map<String, String> extraHeaders) {
        return this.purgeKey(key, this.buildHeaderForSoftPurge(extraHeaders));
    }

    public Future<Response> purgeKey(String key, Map<String, String> extraHeaders) {
        return this.purgeKey(key, extraHeaders, FASTLY_URL);
    }

    public Future<Response> purgeKey(String key, Map<String, String> extraHeaders, String fastlyUrl) {
        String apiUrl = String.format("%s/service/%s/purge/%s", fastlyUrl, this._serviceId, key);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).putAll(extraHeaders).build(), Collections.emptyMap());
    }

    public Future<Response> purgeKeys(List<String> keys) {
        return this.purgeKeys(keys, FASTLY_URL);
    }

    public Future<Response> purgeKeys(List<String> keys, String fastlyUrl) {
        return this.purgeKeys(keys, Collections.emptyMap(), fastlyUrl);
    }

    public Future<Response> softPurgeKeys(List<String> keys) {
        return this.softPurgeKeys(keys, FASTLY_URL);
    }

    public Future<Response> softPurgeKeys(List<String> keys, String fastlyUrl) {
        return this.purgeKeys(keys, this.buildHeaderForSoftPurge(Collections.emptyMap()), fastlyUrl);
    }

    public Future<Response> purgeKeys(List<String> keys, Map<String, String> extraHeaders) {
        return this.purgeKeys(keys, extraHeaders, FASTLY_URL);
    }

    public Future<Response> purgeKeys(List<String> keys, Map<String, String> extraHeaders, String fastlyUrl) {
        Preconditions.checkNotNull(keys, (Object)"keys cannot be null!");
        Preconditions.checkArgument((keys.size() <= 256 ? 1 : 0) != 0, (Object)"Fastly can't purge batches of more than 256 keys");
        String apiUrl = String.format("%s/service/%s/purge", fastlyUrl, this._serviceId);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, (Map<String, String>)ImmutableMap.builder().putAll(this._commonHeaders).putAll(extraHeaders).put((Object)"Surrogate-Key", (Object)SURROGATE_KEY_JOINER.join(keys)).build(), Collections.emptyMap());
    }

    public Future<Response> purgeAll() {
        return this.purgeAll(FASTLY_URL);
    }

    public Future<Response> purgeAll(String fastlyURL) {
        String apiUrl = String.format("%s/service/%s/purge_all", fastlyURL, this._serviceId);
        return this._asyncHttpExecutor.execute(apiUrl, Method.POST, this._commonHeaders, Collections.emptyMap());
    }

    private Map<String, String> buildHeaderForSoftPurge(Map<String, String> extraHeaders) {
        return ImmutableMap.builder().put((Object)"Fastly-Soft-Purge", (Object)"1").putAll(extraHeaders).build();
    }

    public void closeConnectionPool() {
        this._asyncHttpExecutor.close();
    }

    static enum Method {
        POST,
        PURGE,
        PUT,
        GET,
        DELETE;

    }

    private class AsyncHttpExecutorImpl
    implements AsyncHttpExecutor {
        private ExtendedAsyncHttpClient client;
        private AsyncHttpClientConfig defaultConfig = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(50).setMaxRequestRetry(3).setMaxConnections(20000).build();

        public AsyncHttpExecutorImpl() {
            this.client = FastlyApiClient.this._config != null ? new ExtendedAsyncHttpClient(FastlyApiClient.this._config) : new ExtendedAsyncHttpClient(this.defaultConfig);
        }

        @Override
        public void close() {
            this.client.close();
        }

        @Override
        public Future<Response> execute(String apiUrl, Method method, Map<String, String> headers, Map<String, String> parameters) {
            AsyncHttpClient.BoundRequestBuilder request = this.getRequestForMethod(apiUrl, method);
            this.build(request, headers, parameters);
            return request.execute();
        }

        private AsyncHttpClient.BoundRequestBuilder getRequestForMethod(String apiURL, Method method) {
            if (method == Method.PURGE) {
                return this.client.preparePurge(apiURL);
            }
            if (method == Method.POST) {
                return this.client.preparePost(apiURL);
            }
            if (method == Method.PUT) {
                return this.client.preparePut(apiURL);
            }
            if (method == Method.DELETE) {
                return this.client.prepareDelete(apiURL);
            }
            if (method == Method.GET) {
                return this.client.prepareGet(apiURL);
            }
            return null;
        }

        private void build(AsyncHttpClient.BoundRequestBuilder request, Map<String, String> headers, Map<String, String> parameters) {
            FluentCaseInsensitiveStringsMap fluentCaseInsensitiveStringsMap = new FluentCaseInsensitiveStringsMap();
            headers.forEach((arg_0, arg_1) -> ((FluentCaseInsensitiveStringsMap)fluentCaseInsensitiveStringsMap).add(arg_0, arg_1));
            request.setHeaders(fluentCaseInsensitiveStringsMap);
            FluentStringsMap fluentStringsMap = new FluentStringsMap();
            parameters.forEach((arg_0, arg_1) -> ((FluentStringsMap)fluentStringsMap).add(arg_0, arg_1));
            if (request.build().getMethod().equals("GET")) {
                request.setQueryParams((Map)fluentStringsMap);
            } else {
                request.setFormParams((Map)fluentStringsMap);
            }
            String host = headers.get("Host");
            if (host != null) {
                request.setVirtualHost(host);
            }
        }
    }

    @VisibleForTesting
    static interface AsyncHttpExecutor {
        public Future<Response> execute(String var1, Method var2, Map<String, String> var3, Map<String, String> var4);

        public void close();
    }

    static class ExtendedAsyncHttpClient
    extends AsyncHttpClient {
        public ExtendedAsyncHttpClient(AsyncHttpClientConfig config) {
            super(config);
        }

        public AsyncHttpClient.BoundRequestBuilder preparePurge(String url) {
            return this.requestBuilder("PURGE", url);
        }
    }
}

