/*
 * Decompiled with CFR 0.152.
 */
package io.split.diffyreplayer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.split.diffyreplayer.DiffyIdParser;
import io.split.diffyreplayer.DiffyReplayerProperties;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class DiffyReplayerRequestBuilder {
    private static final String CANONICAL_RESOURCE = "Canonical-Resource";
    private final URL destinationURL;
    private final DiffyIdParser idParser;

    public DiffyReplayerRequestBuilder(String destinationURL) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)destinationURL) ? 1 : 0) != 0);
        this.idParser = new DiffyIdParser(DiffyReplayerProperties.INSTANCE.getPatterns());
        this.destinationURL = this.getURLOrBlow(destinationURL);
    }

    public HttpRequestBase build(ContainerRequestContext original) {
        Preconditions.checkNotNull((Object)original);
        String path = this.path(original);
        if (!"GET".equals(original.getMethod())) {
            throw new IllegalArgumentException(String.format("Only GETS are allowed, method %s is is %s", path, original.getMethod()));
        }
        HttpGet get = new HttpGet(this.getURLOrBlow(this.destinationURL, path).toExternalForm());
        this.addHeaders(original, get);
        return get;
    }

    private void addHeaders(ContainerRequestContext original, HttpGet destination) {
        Preconditions.checkNotNull((Object)original);
        Preconditions.checkNotNull((Object)destination);
        destination.addHeader(CANONICAL_RESOURCE, this.idParser.convert(original.getUriInfo().getRequestUri().getRawPath()));
        destination.addHeader("replayer", "true");
        original.getHeaders().forEach((header, list) -> list.forEach(value -> destination.addHeader(header, value)));
    }

    private String path(ContainerRequestContext original) {
        Preconditions.checkNotNull((Object)original);
        return original.getUriInfo().getRequestUri().getRawPath();
    }

    private URL getURLOrBlow(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("URL %s is not valid", url), e);
        }
    }

    private URL getURLOrBlow(URL base, String path) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)base);
        try {
            return new URL(base, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("URL %s is not valid", path), e);
        }
    }
}

