/*
 * Decompiled with CFR 0.152.
 */
package io.split.diffyreplayer;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffyReplayerProperties {
    public static final DiffyReplayerProperties INSTANCE = new DiffyReplayerProperties();
    private final Logger LOG = LoggerFactory.getLogger(DiffyReplayerProperties.class);
    public static final String LOCAL_ENVIRONMENT = "dev";
    private static final String DIFFY_FILE = "/diffyreplayer.properties.%s";
    private static final String ENVIRONMENT = "ENVIRONMENT";
    public static final String DIFFY_THREAD_POOL = "DIFFY_THREAD_POOL";
    public static final String DIFFY_URL = "DIFFY_URL";
    public static final String DIFFY_LOW_RATE = "DIFFY_LOW_RATE";
    public static final String DIFFY_MEDIUM_RATE = "DIFFY_MEDIUM_RATE";
    public static final String DIFFY_HIGH_RATE = "DIFFY_HIGH_RATE";
    private static final String PATTERN_FILE = "PATTERN_FILE";
    private final Properties properties = new Properties();
    private String environment;
    private final Map<Pattern, String> patterns = Maps.newLinkedHashMap();

    private DiffyReplayerProperties() {
        try {
            this.environment = Optional.ofNullable(System.getenv(ENVIRONMENT)).orElse(LOCAL_ENVIRONMENT);
            String envFile = String.format(DIFFY_FILE, this.environment);
            this.LOG.info("diffyreplayer.properties file to be load: " + envFile);
            InputStream diffyProperties = ClassLoader.class.getResourceAsStream(envFile);
            if (diffyProperties != null) {
                this.properties.load(diffyProperties);
                this.LOG.info("Loaded Diffy Replayer properties: " + this.properties.entrySet());
                this.populatePatterns();
            } else {
                this.LOG.warn("Could not find diffyreplayer.properties file");
            }
        }
        catch (IOException e) {
            this.LOG.error("Failed to load properties file for diffy replayer", (Throwable)e);
        }
    }

    public double getLowRate() {
        return Double.valueOf(this.properties.getProperty(DIFFY_LOW_RATE, "0.01"));
    }

    public double getMediumRate() {
        return Double.valueOf(this.properties.getProperty(DIFFY_MEDIUM_RATE, "0.2"));
    }

    public double getHighRate() {
        return Double.valueOf(this.properties.getProperty(DIFFY_HIGH_RATE, "0.5"));
    }

    public String getDiffyUrl() {
        return this.properties.getProperty(DIFFY_URL, "");
    }

    public int getDiffyThreadPool() {
        return Integer.valueOf(this.properties.getProperty(DIFFY_THREAD_POOL, "10"));
    }

    public String getEnvironment() {
        return !Strings.isNullOrEmpty((String)this.environment) ? this.environment : LOCAL_ENVIRONMENT;
    }

    public Map<Pattern, String> getPatterns() {
        return this.patterns;
    }

    private void populatePatterns() {
        String file = this.properties.getProperty(PATTERN_FILE, "");
        if (Strings.isNullOrEmpty((String)file)) {
            return;
        }
        try {
            file = file.startsWith("/") ? file : "/" + file;
            InputStream resource = ClassLoader.class.getResourceAsStream(file);
            if (resource != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] splitted = line.split(",");
                    if (splitted.length > 2 || splitted.length == 1 && !line.endsWith(",")) {
                        throw new IllegalArgumentException(String.format("Line %s is not well formatted", line));
                    }
                    Pattern compile = Pattern.compile(splitted[0]);
                    this.patterns.put(compile, !line.endsWith(",") ? splitted[1] : "");
                }
            } else {
                this.LOG.warn("Could not find diffyreplayer patterns file " + file);
            }
        }
        catch (IOException e) {
            this.LOG.warn("Could not load pattern file " + file, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.LOG.warn("Could not parse pattern file " + file, (Throwable)e);
        }
    }
}

