/*
 * Decompiled with CFR 0.152.
 */
package io.split.diffyreplayer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.split.diffyreplayer.DiffyReplay;
import io.split.diffyreplayer.DiffyReplayer;
import java.lang.reflect.Method;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DiffyReplay
@Provider
public class DiffyReplayerFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DiffyReplayerFilter.class);
    @Context
    private ResourceInfo resourceInfo;
    private final DiffyReplayer diffyReplayer;

    public DiffyReplayerFilter() {
        this.diffyReplayer = DiffyReplayer.INSTANCE;
    }

    @VisibleForTesting
    DiffyReplayerFilter(ResourceInfo resourceInfo, DiffyReplayer diffyReplayer) {
        this.resourceInfo = resourceInfo;
        this.diffyReplayer = diffyReplayer;
    }

    public void filter(ContainerRequestContext original) {
        Preconditions.checkNotNull((Object)original);
        Preconditions.checkNotNull((Object)this.resourceInfo);
        if (!original.getHeaders().containsKey((Object)"replayer") && "GET".equals(original.getMethod())) {
            try {
                Class diffyClass = this.resourceInfo.getResourceClass();
                DiffyReplay diffyReplayClass = diffyClass.getAnnotation(DiffyReplay.class);
                Method diffyMethod = this.resourceInfo.getResourceMethod();
                DiffyReplay diffyReplayMethod = diffyMethod.getAnnotation(DiffyReplay.class);
                if (diffyReplayMethod != null) {
                    this.diffyReplayer.replay(original, diffyReplayMethod.condition().newInstance());
                } else if (diffyReplayClass != null) {
                    this.diffyReplayer.replay(original, diffyReplayClass.condition().newInstance());
                } else {
                    LOG.warn(String.format("Neither class %s nor method %s was annotated with @DiffyReplay, this should never happen", diffyClass.getCanonicalName(), diffyMethod.getName()));
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.warn("Failed to instantiate the condition", (Throwable)e);
            }
        }
    }
}

