/*
 * Decompiled with CFR 0.152.
 */
package io.split.diffyreplayer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.split.diffyreplayer.DiffyReplayerProperties;
import io.split.diffyreplayer.DiffyReplayerRequestBuilder;
import io.split.diffyreplayer.condition.DiffyReplayerCondition;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffyReplayer
implements AutoCloseable {
    public static final DiffyReplayer INSTANCE = new DiffyReplayer();
    private static final Logger LOG = LoggerFactory.getLogger(DiffyReplayer.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(DiffyReplayerProperties.INSTANCE.getDiffyThreadPool());
    private final String diffyUrl = DiffyReplayerProperties.INSTANCE.getDiffyUrl();

    private DiffyReplayer() {
        ((ThreadPoolExecutor)this.executor).setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
    }

    public void replay(ContainerRequestContext original, DiffyReplayerCondition condition) {
        Preconditions.checkNotNull((Object)original);
        this.executor.submit(() -> {
            block16: {
                if (condition.replay() && !Strings.isNullOrEmpty((String)this.diffyUrl)) {
                    LOG.info(String.format("Replaying request %s to url %s", original.getUriInfo().getRequestUri().getRawPath(), this.diffyUrl));
                    DiffyReplayerRequestBuilder builder = new DiffyReplayerRequestBuilder(this.diffyUrl);
                    HttpRequestBase request = builder.build(original);
                    try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode != Response.Status.OK.getStatusCode() && request.getURI() != null) {
                            LOG.warn(String.format("Failed to execute request %s, status code %s, reason %s", request.getURI().toString(), statusCode, response.getStatusLine().getReasonPhrase()));
                        }
                    }
                    catch (IOException e) {
                        if (request.getURI() == null) break block16;
                        LOG.warn(String.format("Failed to execute request %s, reason %s, is Diffy Server up and running?", request.getURI().toString(), e.getMessage()));
                    }
                }
            }
        });
    }

    @Override
    public void close() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

