/*
 * Decompiled with CFR 0.152.
 */
package io.split.diffyreplayer;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Pattern;

public class DiffyIdParser {
    private final Map<Pattern, String> patterns;

    public DiffyIdParser(Map<Pattern, String> patterns) {
        this.patterns = (Map)Preconditions.checkNotNull(patterns);
    }

    public String convert(String uri) {
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
            uri = entry.getKey().matcher(uri).replaceAll(entry.getValue());
        }
        return uri;
    }
}

