/*
 * Decompiled with CFR 0.152.
 */
package redis;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pluggable.CustomStorageWrapper;
import redis.RedisException;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

class RedisImp
implements CustomStorageWrapper {
    private static final String TELEMETRY_INIT = "SPLITIO.telemetry.init";
    private static final String EVENTS_KEY = "SPLITIO.events";
    private static final String IMPRESSIONS_KEY = "SPLITIO.impressions";
    private static final long IMPRESSIONS_OR_EVENTS_DEFAULT_TTL = 3600000L;
    private final JedisPool jedisPool;
    private final String prefix;

    public RedisImp(JedisPool jedisPool, String prefix) {
        this.jedisPool = jedisPool;
        this.prefix = prefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String key) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.buildKeyWithPrefix(key));
            return string;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getMany(List<String> keys) throws Exception {
        if (keys == null) return new ArrayList<String>();
        if (keys.isEmpty()) {
            return new ArrayList<String>();
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            keys = keys.stream().map(key -> this.buildKeyWithPrefix((String)key)).collect(Collectors.toList());
            List list = jedis.mget(keys.toArray(new String[keys.size()]));
            return list;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    public void set(String key, String item) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (key.contains(TELEMETRY_INIT)) {
                String[] splittedKey = key.split("::");
                jedis.hset(this.buildKeyWithPrefix(splittedKey[0]), splittedKey[1], item);
                return;
            }
            jedis.set(this.buildKeyWithPrefix(key), item);
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    public void delete(List<String> keys) throws Exception {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            keys = keys.stream().map(key -> this.buildKeyWithPrefix((String)key)).collect(Collectors.toList());
            jedis.del(keys.toArray(new String[keys.size()]));
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAndSet(String key, String item) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.getSet(this.buildKeyWithPrefix(key), item);
            return string;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getKeysByPrefix(String prefix) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = jedis.keys(this.buildKeyWithPrefix(prefix));
            return set;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long increment(String key, long value) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.incrBy(this.buildKeyWithPrefix(key), value);
            return l;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long decrement(String key, long value) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.decrBy(this.buildKeyWithPrefix(key), value);
            return l;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long pushItems(String key, List<String> items) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            long addedItems = jedis.rpush(this.buildKeyWithPrefix(key), items.toArray(new String[items.size()]));
            if ((EVENTS_KEY.equals(key) || IMPRESSIONS_KEY.equals(key)) && addedItems == (long)items.size()) {
                jedis.pexpire(key, 3600000L);
            }
            long l = addedItems;
            return l;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> popItems(String key, long count) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            String keyWithPrefix = this.buildKeyWithPrefix(key);
            List items = jedis.lrange(keyWithPrefix, 0L, count - 1L);
            int fetchedCount = items.size();
            jedis.ltrim(keyWithPrefix, (long)fetchedCount, -1L);
            List list = items;
            return list;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getItemsCount(String key) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.scard(this.buildKeyWithPrefix(key));
            return l;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean itemContains(String key, String item) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.sismember(this.buildKeyWithPrefix(key), item);
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    public void addItems(String key, List<String> items) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.sadd(this.buildKeyWithPrefix(key), items.toArray(new String[items.size()]));
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    public void removeItems(String key, List<String> items) throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.srem(this.buildKeyWithPrefix(key), items.toArray(new String[items.size()]));
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getItems(List<String> keys) throws Exception {
        if (keys == null) return new ArrayList<String>();
        if (keys.isEmpty()) {
            return new ArrayList<String>();
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            keys = keys.stream().map(key -> this.buildKeyWithPrefix((String)key)).collect(Collectors.toList());
            List list = jedis.mget(keys.toArray(new String[keys.size()]));
            return list;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect() throws Exception {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = "PONG".equalsIgnoreCase(jedis.ping());
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    public boolean disconnect() throws Exception {
        try {
            this.jedisPool.close();
            return true;
        }
        catch (Exception ex) {
            throw new RedisException(ex.getMessage());
        }
    }

    @VisibleForTesting
    String buildKeyWithPrefix(String key) {
        if (!key.startsWith(this.prefix)) {
            key = String.format("%s.%s", this.prefix, key);
        }
        return key;
    }
}

