/*
 * Decompiled with CFR 0.152.
 */
package redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import pluggable.CustomStorageWrapper;
import redis.RedisImp;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisInstance {
    private static final int TIMEOUT = 1000;

    public static Builder builder() {
        return new Builder();
    }

    private static CustomStorageWrapper getRedisInstance(String host, int port, int timeout, String user, String password, int database, String prefix, int maxTotal) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(maxTotal);
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password, database);
        return new RedisImp(jedisPool, prefix);
    }

    private static CustomStorageWrapper getRedisInstance(JedisPool jedisPool, String prefix) {
        return new RedisImp(jedisPool, prefix);
    }

    public static final class Builder {
        private int _timeout = 1000;
        private String _host = "localhost";
        private int _port = 6379;
        private String _user = null;
        private String _password = null;
        private int _database = 0;
        private String _prefix = "";
        private JedisPool _jedisPool = null;
        private int _maxTotal = 8;

        public Builder timeout(int timeout) {
            this._timeout = timeout;
            return this;
        }

        public Builder host(String host) {
            this._host = host;
            return this;
        }

        public Builder port(int port) {
            this._port = port;
            return this;
        }

        public Builder user(String user) {
            this._user = user;
            return this;
        }

        public Builder password(String password) {
            this._password = password;
            return this;
        }

        public Builder database(int database) {
            this._database = database;
            return this;
        }

        public Builder prefix(String prefix) {
            this._prefix = prefix;
            return this;
        }

        public Builder jedisPool(JedisPool jedisPool) {
            this._jedisPool = jedisPool;
            return this;
        }

        public Builder maxTotal(int _maxTotal) {
            return this;
        }

        public CustomStorageWrapper build() {
            if (this._jedisPool != null) {
                return RedisInstance.getRedisInstance(this._jedisPool, this._prefix);
            }
            return RedisInstance.getRedisInstance(this._host, this._port, this._timeout, this._user, this._password, this._database, this._prefix, this._maxTotal);
        }
    }
}

