/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.testing.runner;

import io.split.client.testing.SplitClientForTest;
import io.split.client.testing.annotations.SplitScenario;
import io.split.client.testing.annotations.SplitSuite;
import io.split.client.testing.annotations.SplitTest;
import io.split.client.testing.annotations.SplitTestClient;
import io.split.client.testing.runner.RunWithSplits;
import io.split.client.testing.runner.Scenario;
import io.split.client.testing.runner.Suite;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class SplitTestRunner
extends BlockJUnit4ClassRunner {
    private Suite _globalSplitSuite;
    private Scenario _activeScenario;

    public SplitTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> methods = new ArrayList<FrameworkMethod>(super.computeTestMethods());
        Collections.sort(methods, new Comparator<FrameworkMethod>(){

            @Override
            public int compare(FrameworkMethod o1, FrameworkMethod o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return methods;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        Suite suite = this.generateSuite(method);
        if (suite.isOnlyAllControl()) {
            this.runLeaf(this.methodBlock(method), this.describeChild(method), notifier);
        } else {
            Iterator<Scenario> iterator = suite.scenarios().iterator();
            while (iterator.hasNext()) {
                Scenario scenario;
                this._activeScenario = scenario = iterator.next();
                this.runLeaf(this.methodBlock(method), this.describeScenarioTest(method, scenario), notifier);
                this._activeScenario = null;
            }
        }
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        RunWithSplits withSplits = new RunWithSplits(this._activeScenario, target, statement);
        return super.withBefores(method, target, (Statement)withSplits);
    }

    public Suite generateSuite(FrameworkMethod method) {
        Suite globalSuite = this.getGlobalSuiteCopy();
        Suite methodSuite = method.getAnnotation(SplitTest.class) != null ? new Suite((SplitTest)method.getAnnotation(SplitTest.class)) : (method.getAnnotation(SplitScenario.class) != null ? new Suite((SplitScenario)method.getAnnotation(SplitScenario.class)) : (method.getAnnotation(SplitSuite.class) != null ? new Suite((SplitSuite)method.getAnnotation(SplitSuite.class)) : new Suite()));
        return globalSuite.merge(methodSuite);
    }

    private Suite getGlobalSuiteCopy() {
        if (this._globalSplitSuite == null) {
            this._globalSplitSuite = this.cascadeScenarios(this.getTestClass().getJavaClass());
        }
        return new Suite(this._globalSplitSuite);
    }

    private Suite cascadeScenarios(Class<?> type) {
        Suite suite = type.getSuperclass() != null ? this.cascadeScenarios(type.getSuperclass()) : new Suite();
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SplitTestClient.class) || !field.getType().isAssignableFrom(SplitClientForTest.class)) continue;
            suite.merge(new Suite(field.getAnnotation(SplitTestClient.class)));
        }
        return suite;
    }

    protected Description describeChild(FrameworkMethod method) {
        if (Objects.equals("shouldRun", Thread.currentThread().getStackTrace()[3].getMethodName())) {
            return super.describeChild(method);
        }
        Suite suite = this.generateSuite(method);
        if (!suite.isOnlyAllControl()) {
            Description description = Description.createSuiteDescription((String)this.testName(method), (Annotation[])method.getAnnotations());
            for (Scenario scenario : suite.scenarios()) {
                description.addChild(this.describeScenarioTest(method, scenario));
            }
            return description;
        }
        return super.describeChild(method);
    }

    private Description describeScenarioTest(FrameworkMethod method, Scenario scenario) {
        return Description.createSuiteDescription((String)("[" + scenario.toString() + "] : " + this.testName(method)), (Annotation[])new Annotation[0]);
    }
}

