/*
 * Decompiled with CFR 0.152.
 */
package io.spacebunny.device;

import io.spacebunny.device.SBDevice;
import org.json.JSONException;
import org.json.JSONObject;

public class SBProtocol {
    private static final String PORT_KEY = "port";
    private static final String TLS_PORT_KEY = "tls_port";
    private String name;
    private int port;
    private int tls_port;

    public SBProtocol(String name, int port, int tls_port) {
        this.name = name;
        this.port = port;
        this.tls_port = tls_port;
    }

    public SBProtocol(String name, JSONObject js) throws JSONException {
        this.name = name;
        this.port = js.getInt(PORT_KEY);
        this.tls_port = js.getInt(TLS_PORT_KEY);
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public int getTls_port() {
        return this.tls_port;
    }

    public String toString() {
        return "\nPROTOCOL:\nNAME: " + this.name + "\nPORT: " + this.port + "\nTLS_PORT: " + this.tls_port;
    }

    public static SBProtocol findProtocol(String name, SBDevice device) {
        for (SBProtocol protocol : device.getProtocols()) {
            if (!protocol.getName().equals(name)) continue;
            return protocol;
        }
        return null;
    }
}

