/*
 * Decompiled with CFR 0.152.
 */
package io.spacebunny.device;

import io.spacebunny.SpaceBunny;
import io.spacebunny.device.SBChannel;
import io.spacebunny.device.SBProtocol;
import io.spacebunny.util.Constants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SBDevice {
    private static final String CONNECTION_KEY = "connection";
    private static final String CHANNELS_KEY = "channels";
    private static final String HOST_KEY = "host";
    private static final String PROTOCOLS_KEY = "protocols";
    private static final String DEVICE_NAME_KEY = "device_name";
    private static final String DEVICE_ID_KEY = "device_id";
    private static final String SECRET_KEY = "secret";
    private static final String VHOST_KEY = "vhost";
    private static final Logger LOGGER = Logger.getLogger(SpaceBunny.class.getName());
    private String host;
    private ArrayList<SBProtocol> protocols = new ArrayList(1);
    private ArrayList<SBChannel> channels = new ArrayList();
    private String device_name;
    private String device_id;
    private String secret;
    private String vhost;

    public SBDevice(String device_name, String device_id, String secret, ArrayList<SBProtocol> protocols, ArrayList<SBChannel> channels, String host, String vhost) throws SpaceBunny.ConfigurationException {
        this.host = host;
        this.protocols = protocols;
        this.device_name = device_name;
        this.device_id = device_id;
        this.secret = secret;
        this.vhost = vhost;
        this.channels = channels;
        if (SBProtocol.findProtocol(Constants.DEFAULT_PROTOCOL.getName(), this) == null) {
            this.protocols.add(0, Constants.DEFAULT_PROTOCOL);
        }
        if (this.host == null || this.host.equals("") || this.device_name == null || this.device_name.equals("") || this.device_id == null || this.device_id.equals("") || this.secret == null || this.secret.equals("") || this.vhost == null || this.vhost.equals("")) {
            throw new SpaceBunny.ConfigurationException("Error in Device Configuration!");
        }
        if (this.channels.size() == 0) {
            LOGGER.warning("No channel has been added.");
        }
    }

    public SBDevice(JSONObject jsonObject) throws JSONException {
        JSONObject conn = jsonObject.getJSONObject(CONNECTION_KEY);
        this.host = conn.getString(HOST_KEY);
        JSONObject pr = conn.getJSONObject(PROTOCOLS_KEY);
        Iterator keys = pr.keys();
        this.protocols.add(Constants.DEFAULT_PROTOCOL);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            SBProtocol newProtocol = new SBProtocol(key, pr.getJSONObject(key));
            if (newProtocol.getName().equals(Constants.DEFAULT_PROTOCOL.getName())) {
                this.protocols.remove(Constants.DEFAULT_PROTOCOL);
            }
            this.protocols.add(newProtocol);
        }
        this.device_name = conn.getString(DEVICE_NAME_KEY);
        this.device_id = conn.getString(DEVICE_ID_KEY);
        this.secret = conn.getString(SECRET_KEY);
        this.vhost = conn.getString(VHOST_KEY);
        JSONArray ch = jsonObject.getJSONArray(CHANNELS_KEY);
        for (int i = 0; i < ch.length(); ++i) {
            this.channels.add(new SBChannel(ch.getJSONObject(i)));
        }
    }

    public ArrayList<SBProtocol> getProtocols() {
        return this.protocols;
    }

    public ArrayList<SBChannel> getChannels() {
        return this.channels;
    }

    public String getHost() {
        return this.host;
    }

    public String getDevice_name() {
        return this.device_name;
    }

    public String getDevice_id() {
        return this.device_id;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getVhost() {
        return this.vhost;
    }

    public String toString() {
        return "\nHOST: " + this.host + "\nPROTOCOLS: " + this.protocols.toString() + "\nDEVICE NAME: " + this.device_name + "\nDEVICE_ID: " + this.device_id + "\nSECRET: " + this.secret + "\nVHOST: " + this.vhost + "\n" + this.channels.toString();
    }

    public static class Builder {
        private String host;
        private ArrayList<SBProtocol> protocols = new ArrayList(1);
        private ArrayList<SBChannel> channels = new ArrayList();
        private String device_name;
        private String device_id;
        private String secret;
        private String vhost;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setDeviceName(String device_name) {
            this.device_name = device_name;
            return this;
        }

        public Builder setDeviceId(String device_id) {
            this.device_id = device_id;
            return this;
        }

        public Builder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder setVHost(String vhost) {
            this.vhost = vhost;
            return this;
        }

        public Builder setProtocols(ArrayList<SBProtocol> protocols) {
            this.protocols = protocols;
            return this;
        }

        public Builder setChannels(ArrayList<SBChannel> channels) {
            this.channels = channels;
            return this;
        }

        public SBDevice getDevice() throws SpaceBunny.ConfigurationException {
            return new SBDevice(this.device_name, this.device_id, this.secret, this.protocols, this.channels, this.host, this.vhost);
        }
    }
}

