/*
 * Decompiled with CFR 0.152.
 */
package io.spacebunny.device;

import io.spacebunny.SpaceBunny;
import io.spacebunny.device.SBDevice;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SBChannel {
    private static final Logger LOGGER = Logger.getLogger(SpaceBunny.class.getName());
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private String id;
    private String name;

    public SBChannel(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public SBChannel(JSONObject jsonObject) throws JSONException {
        this.id = jsonObject.getString(ID_KEY);
        this.name = jsonObject.getString(NAME_KEY);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "\nChannel:\nID: " + this.id + "\nNAME: " + this.name;
    }

    public static SBChannel findChannel(String name, SBDevice device) {
        if (device != null) {
            for (SBChannel channel : device.getChannels()) {
                if (!channel.getName().equals(name)) continue;
                return channel;
            }
        }
        return null;
    }
}

