/*
 * Decompiled with CFR 0.152.
 */
package io.spacebunny;

import com.rabbitmq.client.ConfirmListener;
import io.spacebunny.connection.RabbitConnection;
import io.spacebunny.device.SBChannel;
import io.spacebunny.device.SBDevice;
import io.spacebunny.device.SBProtocol;
import io.spacebunny.util.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class SpaceBunny {
    private static final Logger LOGGER = Logger.getLogger(SpaceBunny.class.getName());

    private static String generateHostname(boolean tls) {
        return (tls ? "https://api.spacebunny.io" : "http://api.spacebunny.io") + "/v1" + "/device_configurations";
    }

    private static void addCA(String path) throws ConfigurationException {
        block15: {
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                String ksPath = System.getProperty("java.home") + "\\lib\\security\\cacerts\\";
                keyStore.load(new FileInputStream(ksPath), "changeit".toCharArray());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                File f = new File(URLDecoder.decode(path, "UTF-8"));
                if (f.exists()) {
                    try (BufferedInputStream caInput = new BufferedInputStream(new FileInputStream(f.getPath()));){
                        Certificate crt = cf.generateCertificate(caInput);
                        keyStore.setCertificateEntry(f.getName(), crt);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(keyStore);
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, tmf.getTrustManagers(), null);
                        SSLContext.setDefault(sslContext);
                        break block15;
                    }
                }
                throw new ConfigurationException("Error with custom CA path.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConfigurationException("Error with custom CA.");
            }
        }
    }

    private static void setDefaultCA() throws ConfigurationException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String ksPath = System.getProperty("java.home") + "\\lib\\security\\cacerts\\";
            keyStore.load(new FileInputStream(ksPath), "changeit".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (BufferedInputStream caInput = new BufferedInputStream(SpaceBunny.class.getResourceAsStream("/lets-encrypt-x3-cross-signed.pem"));){
                Certificate crt = cf.generateCertificate(caInput);
                keyStore.setCertificateEntry("lets-encrypt-x3-cross-signed", crt);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), null);
                SSLContext.setDefault(sslContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException("Error with custom CA.");
        }
    }

    public static interface OnMessageReceivedListener {
        public void onReceived(String var1) throws ConnectionException;
    }

    public static interface OnConnectedListener {
        public void onConnected() throws ConnectionException;
    }

    public static interface OnFinishConfigiurationListener {
        public void onConfigured(SBDevice var1) throws ConnectionException;
    }

    public static class ConnectionException
    extends Exception {
        public ConnectionException(String message) {
            super(message);
        }

        public ConnectionException(Exception ex) {
            super(ex.getMessage());
        }
    }

    public static class ConfigurationException
    extends Exception {
        public ConfigurationException(String message) {
            super(message);
        }

        public ConfigurationException(Exception ex) {
            super(ex.getMessage());
        }
    }

    public static class Client {
        private SBDevice device = null;
        private RabbitConnection rabbitConnection = null;
        private OnFinishConfigiurationListener configCallBack = null;
        private String device_key;
        private boolean tls = true;
        private boolean verify_ca = true;
        private boolean custom_certificate = false;

        public Client(String device_key) throws ConfigurationException {
            if (device_key == null || device_key.equals("")) {
                throw new ConfigurationException("Device configuration error.");
            }
            this.device_key = device_key;
        }

        public Client(SBDevice device) throws ConfigurationException {
            if (device == null) {
                throw new ConfigurationException("Device configuration error.");
            }
            this.device = device;
        }

        public void connect() throws ConnectionException {
            this.connect(null, null);
        }

        public void connect(OnConnectedListener onConnectedListener) throws ConnectionException {
            this.connect(null, onConnectedListener);
        }

        public void connect(SBProtocol protocol, OnConnectedListener onConnectedListener) throws ConnectionException {
            try {
                this.configure();
                if (protocol != null) {
                    LOGGER.warning("Custom protocol not supported!");
                }
                protocol = Constants.DEFAULT_PROTOCOL;
                this.rabbitConnection = new RabbitConnection(protocol, this.tls);
                if (this.rabbitConnection.connect(this.device) && onConnectedListener != null) {
                    onConnectedListener.onConnected();
                }
            }
            catch (Exception ex) {
                throw new ConnectionException(ex);
            }
        }

        public boolean isConnected() {
            return this.rabbitConnection.isConnected();
        }

        public void testConnection() throws ConnectionException {
            if (!this.isConnected()) {
                throw new ConnectionException("Space Bunny is not connected. Try spaceBunny.connect().");
            }
        }

        public void setPathCustomCA(String path) throws ConfigurationException {
            SpaceBunny.addCA(path);
            this.custom_certificate = true;
        }

        private void configure() throws KeyManagementException, NoSuchAlgorithmException, IOException, JSONException, ConnectionException {
            try {
                String inputStr;
                if (this.tls) {
                    if (!this.verify_ca) {
                        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return null;
                            }

                            @Override
                            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                            }
                        }};
                        SSLContext sc = SSLContext.getInstance("TLS");
                        sc.init(null, trustAllCerts, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    } else if (!this.custom_certificate) {
                        SpaceBunny.setDefaultCA();
                    }
                }
                URL url = new URL(SpaceBunny.generateHostname(this.tls));
                URLConnection uc = url.openConnection();
                uc.setRequestProperty("Device-Key", this.device_key);
                BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                StringBuilder responseStrBuilder = new StringBuilder();
                while ((inputStr = reader.readLine()) != null) {
                    responseStrBuilder.append(inputStr);
                }
                this.device = new SBDevice(new JSONObject(responseStrBuilder.toString()));
                if (this.configCallBack != null) {
                    this.configCallBack.onConfigured(this.device);
                }
            }
            catch (Exception e) {
                throw new ConnectionException(e);
            }
        }

        public void setOnFinishConfigiurationListener(OnFinishConfigiurationListener callBack) {
            this.configCallBack = callBack;
        }

        public void publish(final String channelName, final String msg, final Map<String, Object> headers, final ConfirmListener confirmListener) throws ConnectionException {
            this.testConnection();
            new Thread(){

                @Override
                public void run() {
                    try {
                        SBChannel channel = SBChannel.findChannel(channelName, Client.this.device);
                        Client.this.rabbitConnection.publish(Client.this.device.getDevice_id(), channelName, msg, headers, confirmListener);
                        if (channel == null) {
                            LOGGER.warning("The channel does not exist!");
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warning(ex.getMessage());
                    }
                }
            }.start();
        }

        public void receive(OnMessageReceivedListener onMessageReceived) throws ConnectionException {
            this.testConnection();
            try {
                onMessageReceived.onReceived(this.rabbitConnection.receive(this.device.getDevice_id()));
            }
            catch (Exception ex) {
                throw new ConnectionException(ex);
            }
        }

        public void subscribe(RabbitConnection.OnSubscriptionMessageReceivedListener onMessageReceived) throws ConnectionException {
            this.testConnection();
            try {
                this.rabbitConnection.subscribe(this.device.getDevice_id(), onMessageReceived);
            }
            catch (Exception ex) {
                throw new ConnectionException(ex);
            }
        }

        public void unsubscribe() throws ConnectionException {
            this.testConnection();
            try {
                this.rabbitConnection.unsubscribe(this.device.getDevice_id());
            }
            catch (Exception ex) {
                throw new ConnectionException(ex);
            }
        }

        public void setTls(boolean tls) {
            this.tls = tls;
        }

        public boolean istls() {
            return this.tls;
        }

        public void setVerifyCA(boolean verify) {
            this.verify_ca = verify;
        }

        public boolean isCAVerifed() {
            return this.verify_ca;
        }

        public ArrayList<SBProtocol> getProtocols() {
            return this.device.getProtocols();
        }

        public ArrayList<SBChannel> getChannels() {
            return this.device.getChannels();
        }

        public void close() throws ConnectionException {
            this.testConnection();
            try {
                this.rabbitConnection.close();
            }
            catch (Exception ex) {
                throw new ConnectionException(ex);
            }
        }

        public SBDevice getDevice() {
            return this.device;
        }

        public SBProtocol getDefaultProtocol() {
            return Constants.DEFAULT_PROTOCOL;
        }

        public boolean existsChannel(String channelName) {
            return SBChannel.findChannel(channelName, this.device) != null;
        }
    }
}

