/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.writer;

import io.sovaj.basics.core.utlis.SystemTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RestItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private MediaType outputFormat;
    private String endpoinUrl;
    private String path;
    private List<MessageBodyWriter<T>> providers;
    private boolean singleCommit = false;
    private static final AtomicLong nbElementSent = new AtomicLong(0L);
    private boolean debugEnabled;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final DateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Logger LOGGER = LoggerFactory.getLogger(RestItemWriter.class);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.endpoinUrl);
        Assert.notNull((Object)this.path);
        Assert.notNull(this.providers);
        Assert.notNull((Object)this.outputFormat);
        this.debugEnabled = LOGGER.isDebugEnabled();
    }

    public void write(List<? extends T> items) throws Exception {
        WebClient client = WebClient.create((String)this.endpoinUrl, this.providers);
        client = client.accept(new MediaType[]{this.outputFormat}).type(this.outputFormat).path((Object)this.path);
        client.header("Date", new Object[]{SDF.format(SystemTime.asDate())});
        if (this.singleCommit) {
            for (T item : items) {
                Response response = client.post(item);
                if (response.getStatus() < 400) continue;
                throw new RuntimeException("Batch fail to send data to :  " + this.endpoinUrl + this.path, new RuntimeException(response.getStatus() + " error code thrown by the service"));
            }
        } else {
            Response response = client.post(items);
            if (response.getStatus() >= 400) {
                throw new RuntimeException("Batch fail to send data to :  " + this.endpoinUrl + this.path, new RuntimeException(response.getStatus() + " error code thrown by the service"));
            }
        }
        if (this.debugEnabled) {
            LOGGER.debug("{} element(s) sent so far ", (Object)nbElementSent.addAndGet(items.size()));
        }
    }

    public void send(List<? extends T> items) {
    }

    public String getEndpoinUrl() {
        return this.endpoinUrl;
    }

    public void setEndpoinUrl(String endpoinUrl) {
        this.endpoinUrl = endpoinUrl;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<MessageBodyWriter<T>> getProviders() {
        return this.providers;
    }

    public void setProviders(List<MessageBodyWriter<T>> providers) {
        this.providers = providers;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = MediaType.valueOf((String)outputFormat);
    }

    public boolean isSingleCommit() {
        return this.singleCommit;
    }

    public void setSingleCommit(boolean singleCommit) {
        this.singleCommit = singleCommit;
    }
}

