/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.statetementsetter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.jdbc.core.PreparedStatementSetter;

public class PaginationStatementSetter
implements PreparedStatementSetter {
    private static final AtomicLong PAGE = new AtomicLong(0L);
    private Integer pageSize;

    public void setValues(PreparedStatement ps) throws SQLException {
        long pg = PAGE.getAndIncrement();
        ps.setLong(1, pg * (long)this.pageSize.intValue());
        ps.setLong(2, (pg + 1L) * (long)this.pageSize.intValue());
    }

    public void setPageSize(int pPageSize) {
        this.pageSize = pPageSize;
    }
}

