/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MultiThreadedJdbcItemReader<T>
implements ItemReader<T>,
InitializingBean,
BeanNameAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiThreadedJdbcItemReader.class);
    private DataSource dataSource;
    private String sql;
    private String fileName;
    private RowMapper<T> rowMapper;
    private PreparedStatementSetter preparedStatementSetter;
    private JdbcTemplate jdbcTemplate;
    private boolean logErrors = true;
    private final ThreadLocal<ResultsHolder<T>> resultsHolderTL = new ThreadLocal();
    private final List<ResultsHolder<T>> resultsHolders = new ArrayList<ResultsHolder<T>>();
    private boolean disabled = false;
    private boolean threadIsolation = false;
    private String beanName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource);
        Assert.isTrue((this.sql == null || this.fileName == null ? 1 : 0) != 0, (String)"La propri\ufffdt\ufffd sql ou fileName doit \ufffdtre renseign\ufffd mais pas les deux en m\ufffdme temps");
        Assert.isTrue((this.sql != null || this.fileName != null ? 1 : 0) != 0, (String)"La propri\ufffdt\ufffd sql ou fileName doit \ufffdtre renseign\ufffd");
        if (this.fileName != null) {
            String codeSql = this.sqlFileToString();
            this.setSql(codeSql);
        }
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    public T read() throws Exception {
        if (this.disabled) {
            LOGGER.info("Reader {} is disabled --> returning null", (Object)this.beanName);
            return null;
        }
        T result = this.localGet();
        if (result != null) {
            return result;
        }
        if (!this.threadIsolation) {
            result = this.globalGet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T localGet() throws Exception {
        Object object;
        boolean debugEnabled = LOGGER.isDebugEnabled();
        ResultsHolder<T> resultsHolder = this.resultsHolderTL.get();
        if (resultsHolder == null) {
            resultsHolder = new ResultsHolder();
            this.resultsHolderTL.set(resultsHolder);
            object = this.resultsHolders;
            synchronized (object) {
                this.resultsHolders.add(resultsHolder);
            }
            if (debugEnabled) {
                LOGGER.debug("ResultsHolder {} created", resultsHolder);
            }
        } else if (((ResultsHolder)resultsHolder).exhausted) {
            if (debugEnabled) {
                LOGGER.debug("ResultsHolder {} exhausted ; returning null", resultsHolder);
            }
            return null;
        }
        if (debugEnabled) {
            LOGGER.debug("Locally polling resultsHolder {}...", resultsHolder);
        }
        object = resultsHolder;
        synchronized (object) {
            Object result = ((ResultsHolder)resultsHolder).queue.poll();
            if (debugEnabled) {
                LOGGER.debug("Locally polled resultsHolder {} : {}", resultsHolder, result);
            }
            if (result == null) {
                List<T> results = this.dbRead();
                if (results.isEmpty()) {
                    ((ResultsHolder)resultsHolder).exhausted = true;
                    List<ResultsHolder<T>> list = this.resultsHolders;
                    synchronized (list) {
                        this.resultsHolders.remove(resultsHolder);
                    }
                    if (debugEnabled) {
                        LOGGER.debug("ResultsHolder {} has been set exhausted", resultsHolder);
                    }
                } else {
                    ((ResultsHolder)resultsHolder).queue.addAll(results);
                    result = ((ResultsHolder)resultsHolder).queue.poll();
                    if (debugEnabled) {
                        LOGGER.debug("Returning locally cached result {}", result);
                    }
                }
            }
            return (T)result;
        }
    }

    private List<T> dbRead() throws Exception {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Jdbc read : {}", (Object)this.sql);
            }
            List results = null;
            long start = 0L;
            if (LOGGER.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            results = this.jdbcTemplate.query(this.sql, this.preparedStatementSetter, this.rowMapper);
            if (LOGGER.isInfoEnabled()) {
                long stop = System.currentTimeMillis();
                LOGGER.info("Jdbc read took " + (stop - start) + " ms");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Jdbc read ok ({} results)", (Object)results.size());
            }
            return results;
        }
        catch (Exception e) {
            if (this.logErrors) {
                LOGGER.error("Read error", (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T globalGet() {
        ArrayList<ResultsHolder<T>> resultsHoldersCopy;
        List<ResultsHolder<T>> list = this.resultsHolders;
        synchronized (list) {
            resultsHoldersCopy = new ArrayList<ResultsHolder<T>>(this.resultsHolders);
        }
        boolean debugEnabled = LOGGER.isDebugEnabled();
        if (debugEnabled) {
            LOGGER.debug("Getting a result from all resultsHolders...");
        }
        for (ResultsHolder<T> resultsHolder : resultsHoldersCopy) {
            if (((ResultsHolder)resultsHolder).exhausted) continue;
            if (debugEnabled) {
                LOGGER.debug("Globally polling resultHolders {}...", resultsHolder);
            }
            ResultsHolder<T> resultsHolder2 = resultsHolder;
            synchronized (resultsHolder2) {
                Object result = ((ResultsHolder)resultsHolder).queue.poll();
                if (result != null) {
                    if (debugEnabled) {
                        LOGGER.debug("Globally polled resultHolders {} : {}", resultsHolder, result);
                    }
                    return (T)result;
                }
            }
        }
        if (debugEnabled) {
            LOGGER.debug("No results found from any resultHolders ; cleaning...");
        }
        ResultsHolder<T> resultsHolder = this.resultsHolderTL.get();
        this.resultsHolderTL.remove();
        List<ResultsHolder<T>> list2 = this.resultsHolders;
        synchronized (list2) {
            this.resultsHolders.remove(resultsHolder);
        }
        if (debugEnabled) {
            LOGGER.debug("Cleaned out");
        }
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setPreparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public void setLogErrors(boolean logErrors) {
        this.logErrors = logErrors;
    }

    public boolean isLogErrors() {
        return this.logErrors;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String sqlFileToString() {
        String codeSql = "";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.fileName);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            codeSql = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return codeSql;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        if (this.beanName == null) {
            return super.toString();
        }
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.beanName + "]";
    }

    public boolean isThreadIsolation() {
        return this.threadIsolation;
    }

    public void setThreadIsolation(boolean threadIsolation) {
        this.threadIsolation = threadIsolation;
    }

    private static class ResultsHolder<T> {
        private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
        private boolean exhausted;
    }
}

