/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.reader;

import io.sovaj.basics.spring.batch.reader.HibernatePrepareQuery;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.IOUtils;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MultiThreadedHibernateItemReader<T>
implements ItemReader<T>,
InitializingBean,
BeanNameAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiThreadedHibernateItemReader.class);
    private String sql;
    private String fileName;
    private SessionFactory sessionFactory;
    private HibernatePrepareQuery hibernatePrepareQuery;
    private final ThreadLocal<ResultsHolder<T>> resultsHolderTL = new ThreadLocal();
    private final List<ResultsHolder<T>> resultsHolders = new ArrayList<ResultsHolder<T>>();
    private String beanName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionFactory);
        Assert.notNull((Object)this.hibernatePrepareQuery);
        Assert.isTrue((this.sql == null || this.fileName == null ? 1 : 0) != 0, (String)"La propri\u00e9t\u00e9 sql ou fileName doit \u00eatre renseign\u00e9 mais pas les deux en m\u00eame temps");
        Assert.isTrue((this.sql != null || this.fileName != null ? 1 : 0) != 0, (String)"La propri\u00e9t\u00e9 sql ou fileName doit \u00eatre renseign\u00e9");
        if (this.fileName != null) {
            String codeSql = this.sqlFileToString();
            this.setSql(codeSql);
        }
    }

    public T read() throws Exception {
        T result = this.localGet();
        if (result != null) {
            return result;
        }
        result = this.globalGet();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T localGet() throws Exception {
        Object object;
        boolean debugEnabled = LOGGER.isDebugEnabled();
        ResultsHolder<T> resultsHolder = this.resultsHolderTL.get();
        if (resultsHolder == null) {
            resultsHolder = new ResultsHolder();
            this.resultsHolderTL.set(resultsHolder);
            object = this.resultsHolders;
            synchronized (object) {
                this.resultsHolders.add(resultsHolder);
            }
            if (debugEnabled) {
                LOGGER.debug("ResultsHolder {} created", resultsHolder);
            }
        } else if (((ResultsHolder)resultsHolder).exhausted) {
            if (debugEnabled) {
                LOGGER.debug("ResultsHolder {} exhausted ; returning null", resultsHolder);
            }
            return null;
        }
        if (debugEnabled) {
            LOGGER.debug("Locally polling resultsHolder {}...", resultsHolder);
        }
        object = resultsHolder;
        synchronized (object) {
            Object result = ((ResultsHolder)resultsHolder).queue.poll();
            if (debugEnabled) {
                LOGGER.debug("Locally polled resultsHolder {} : {}", resultsHolder, result);
            }
            if (result == null) {
                List<T> results = this.dbRead();
                if (results.isEmpty()) {
                    ((ResultsHolder)resultsHolder).exhausted = true;
                    List<ResultsHolder<T>> list = this.resultsHolders;
                    synchronized (list) {
                        this.resultsHolders.remove(resultsHolder);
                    }
                    if (debugEnabled) {
                        LOGGER.debug("ResultsHolder {} has been set exhausted", resultsHolder);
                    }
                } else {
                    ((ResultsHolder)resultsHolder).queue.addAll(results);
                    result = ((ResultsHolder)resultsHolder).queue.poll();
                    if (debugEnabled) {
                        LOGGER.debug("Returning locally cached result {}", result);
                    }
                }
            }
            return (T)result;
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private List<T> dbRead() throws Exception {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Jdbc read : {}", (Object)this.sql);
            }
            long start = 0L;
            if (LOGGER.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            List results = this.hibernatePrepareQuery.prepareQuery(this.sessionFactory.getCurrentSession().createQuery(this.sql)).list();
            if (LOGGER.isInfoEnabled()) {
                long stop = System.currentTimeMillis();
                LOGGER.info("Jdbc read took " + (stop - start) + " ms");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Jdbc read ok ({} results)", (Object)results.size());
            }
            return results;
        }
        catch (HibernateException e) {
            LOGGER.error("Read error", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T globalGet() {
        ArrayList<ResultsHolder<T>> resultsHoldersCopy;
        List<ResultsHolder<T>> list = this.resultsHolders;
        synchronized (list) {
            resultsHoldersCopy = new ArrayList<ResultsHolder<T>>(this.resultsHolders);
        }
        boolean debugEnabled = LOGGER.isDebugEnabled();
        if (debugEnabled) {
            LOGGER.debug("Getting a result from all resultsHolders...");
        }
        for (ResultsHolder<T> resultsHolder : resultsHoldersCopy) {
            if (((ResultsHolder)resultsHolder).exhausted) continue;
            if (debugEnabled) {
                LOGGER.debug("Globally polling resultHolders {}...", resultsHolder);
            }
            ResultsHolder<T> resultsHolder2 = resultsHolder;
            synchronized (resultsHolder2) {
                Object result = ((ResultsHolder)resultsHolder).queue.poll();
                if (result != null) {
                    if (debugEnabled) {
                        LOGGER.debug("Globally polled resultHolders {} : {}", resultsHolder, result);
                    }
                    return (T)result;
                }
            }
        }
        if (debugEnabled) {
            LOGGER.debug("No results found from any resultHolders ; cleaning...");
        }
        ResultsHolder<T> resultsHolder = this.resultsHolderTL.get();
        this.resultsHolderTL.remove();
        List<ResultsHolder<T>> list2 = this.resultsHolders;
        synchronized (list2) {
            this.resultsHolders.remove(resultsHolder);
        }
        if (debugEnabled) {
            LOGGER.debug("Cleaned out");
        }
        return null;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String sqlFileToString() throws IOException {
        String codeSql = "";
        InputStream inputStream = this.getClass().getResourceAsStream(this.fileName);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        codeSql = writer.toString();
        return codeSql;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public HibernatePrepareQuery getHibernatePrepareQuery() {
        return this.hibernatePrepareQuery;
    }

    public void setHibernatePrepareQuery(HibernatePrepareQuery hibernatePrepareQuery) {
        this.hibernatePrepareQuery = hibernatePrepareQuery;
    }

    public String toString() {
        if (this.beanName == null) {
            return super.toString();
        }
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.beanName + "]";
    }

    private static class ResultsHolder<T> {
        private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
        private boolean exhausted;
    }
}

