/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.reader;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ItemReaderWrapper<T>
implements ItemStreamReader<T>,
InitializingBean,
BeanNameAware {
    private ItemReader<T> itemReader;
    private String beanName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.itemReader, (String)"itemReader is mandatory");
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.itemReader instanceof ItemStream) {
            ((ItemStream)this.itemReader).open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.itemReader instanceof ItemStream) {
            ((ItemStream)this.itemReader).update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.itemReader instanceof ItemStream) {
            ((ItemStream)this.itemReader).close();
        }
    }

    public T read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        return (T)this.itemReader.read();
    }

    public void setItemReader(ItemReader<T> itemReader) {
        this.itemReader = itemReader;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String toString() {
        if (this.beanName == null) {
            return super.toString();
        }
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.beanName + "]";
    }
}

