/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.reader;

import io.sovaj.basics.spring.batch.reader.ItemReaderWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

public class DisableableItemReader<T>
extends ItemReaderWrapper<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private boolean disabled = false;

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.disabled) {
            this.LOGGER.info("Reader is disabled ; skip open");
        } else {
            super.open(executionContext);
        }
    }

    @Override
    public T read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        if (this.disabled) {
            this.LOGGER.info("Reader is disabled ; skip read");
            return null;
        }
        return super.read();
    }

    @Override
    public void close() throws ItemStreamException {
        if (this.disabled) {
            this.LOGGER.info("Reader is disabled ; skip close");
        } else {
            super.close();
        }
    }

    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

