/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.Assert;

public class SQLJobExecutionListener
implements JobExecutionListener,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLJobExecutionListener.class);
    private String loadSQL;
    private String loadSQLFileName;
    private String clearSQL;
    private String clearSQLFileName;
    private JdbcOperations jdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        String codeSql;
        Assert.isTrue((this.loadSQL == null || this.loadSQLFileName == null ? 1 : 0) != 0, (String)"One of the loadSQL or loadSQLFileName property have to be set");
        Assert.isTrue((this.loadSQL != null || this.loadSQLFileName != null ? 1 : 0) != 0, (String)"loadSQL ou loadSQLFileName property have to be set");
        if (this.loadSQLFileName != null) {
            codeSql = this.sqlFileToString(this.loadSQLFileName);
            this.setLoadSQL(codeSql);
        }
        Assert.isTrue((this.clearSQL == null || this.clearSQLFileName == null ? 1 : 0) != 0, (String)"One of the clearSQL or clearSQLFileName property have to be set");
        Assert.isTrue((this.clearSQL != null || this.clearSQLFileName != null ? 1 : 0) != 0, (String)"clearSQL ou clearSQLFileName property have to be set");
        if (this.loadSQLFileName != null) {
            codeSql = this.sqlFileToString(this.clearSQLFileName);
            this.setClearSQL(codeSql);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        LOGGER.info("Clearing temporary merchant into temporary table");
        this.jdbcTemplate.execute(this.clearSQL);
        LOGGER.info("Temporary merchant table cleared");
        LOGGER.info("Loading temporary merchant into temporary table ");
        this.jdbcTemplate.execute(this.loadSQL);
        LOGGER.info("Temporary merchant loaded");
    }

    public void afterJob(JobExecution jobExecution) {
        LOGGER.info("Clearing temporary merchant into temporary table");
        this.jdbcTemplate.execute(this.clearSQL);
        LOGGER.info("Temporary merchant table cleared");
    }

    private String sqlFileToString(String sqlFileName) throws IOException {
        String codeSql = "";
        InputStream inputStream = this.getClass().getResourceAsStream(sqlFileName);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        codeSql = writer.toString();
        return codeSql;
    }

    public String getLoadSQL() {
        return this.loadSQL;
    }

    public void setLoadSQL(String loadSQL) {
        this.loadSQL = loadSQL;
    }

    public String getLoadSQLFileName() {
        return this.loadSQLFileName;
    }

    public void setLoadSQLFileName(String loadSQLFileName) {
        this.loadSQLFileName = loadSQLFileName;
    }

    public String getClearSQL() {
        return this.clearSQL;
    }

    public void setClearSQL(String clearSQL) {
        this.clearSQL = clearSQL;
    }

    public String getClearSQLFileName() {
        return this.clearSQLFileName;
    }

    public void setClearSQLFileName(String clearSQLFileName) {
        this.clearSQLFileName = clearSQLFileName;
    }

    public JdbcOperations getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

