/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.listener;

import io.sovaj.basics.core.utlis.SystemTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RestJobExecutionListener
implements JobExecutionListener,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestJobExecutionListener.class);
    private static final Date NOW = SystemTime.asDate();
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final DateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private String endpoinUrl;
    public static final String endpoinUrlJobParameterName = "output.endpoint.url";
    private String initPath;
    public static final String initPathJobParameterName = "output.endpoint.initpath";
    private String destroyPath;
    public static final String destroyPathJobParameterName = "output.endpoint.destroypath";
    private MediaType outputFormat;
    public static final String outputFormatJobParameterName = "output.format";
    private List<MessageBodyWriter> providers;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.providers);
    }

    public void beforeJob(JobExecution jobExecution) {
        this.init(jobExecution);
        if (StringUtils.trimToNull((String)this.initPath) != null) {
            LOGGER.info("Calling init method on " + this.endpoinUrl + this.initPath);
            WebClient client = WebClient.create((String)this.endpoinUrl, this.providers);
            client = client.accept(new MediaType[]{this.outputFormat}).type(this.outputFormat).path((Object)this.initPath);
            client.header("Date", new Object[]{SDF.format(NOW)});
            Response response = client.post(null);
            if (response.getStatus() >= 400) {
                throw new RuntimeException("Batch fail to send data to : " + this.endpoinUrl + this.initPath, new RuntimeException(response.getStatusInfo().getReasonPhrase()));
            }
        } else {
            LOGGER.info("No init method called ");
        }
    }

    public void afterJob(JobExecution jobExecution) {
        if (StringUtils.trimToNull((String)this.destroyPath) != null) {
            LOGGER.info("Calling destroy method on " + this.endpoinUrl + this.initPath);
            WebClient client = WebClient.create((String)this.endpoinUrl, this.providers);
            client = client.accept(new MediaType[]{this.outputFormat}).type(this.outputFormat).path((Object)this.destroyPath);
            client.header("Date", new Object[]{SDF.format(NOW)});
            Response response = client.post(null);
            if (response.getStatus() >= 400) {
                throw new RuntimeException("Batch fail to send data to : " + this.endpoinUrl + this.initPath, new RuntimeException(response.getStatusInfo().getReasonPhrase()));
            }
        } else {
            LOGGER.info("No destroy method called ");
        }
    }

    public String getEndpoinUrl() {
        return this.endpoinUrl;
    }

    public void setEndpoinUrl(String endpoinUrl) {
        this.endpoinUrl = endpoinUrl;
    }

    public String getInitPath() {
        return this.initPath;
    }

    public void setInitPath(String initPath) {
        this.initPath = initPath;
    }

    public String getDestroyPath() {
        return this.destroyPath;
    }

    public void setDestroyPath(String destroyPath) {
        this.destroyPath = destroyPath;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = MediaType.valueOf((String)outputFormat);
    }

    public List<MessageBodyWriter> getProviders() {
        return this.providers;
    }

    public void setProviders(List<MessageBodyWriter> providers) {
        this.providers = providers;
    }

    private void init(JobExecution jobExecution) {
        this.setEndpoinUrl(jobExecution.getJobParameters().getString(endpoinUrlJobParameterName, null));
        this.setDestroyPath(jobExecution.getJobParameters().getString(destroyPathJobParameterName, null));
        this.setInitPath(jobExecution.getJobParameters().getString(initPathJobParameterName, null));
        this.setOutputFormat(jobExecution.getJobParameters().getString(outputFormatJobParameterName, null));
        Assert.notNull((Object)this.endpoinUrl);
        Assert.notNull((Object)this.outputFormat);
    }
}

