/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.listener;

import io.sovaj.basics.spring.batch.listener.AbstractLoggingExecutionListener;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;

public class LoggingExecutionListener<T, S>
extends AbstractLoggingExecutionListener
implements StepExecutionListener,
ChunkListener,
ItemReadListener<T>,
ItemProcessListener<T, S>,
ItemWriteListener<S>,
SkipListener<T, S> {
    public void beforeStep(StepExecution stepExecution) {
        Logger stepLogger = this.getStepLogger();
        if (stepLogger.isInfoEnabled()) {
            stepLogger.info("beforeStep ; {}", (Object)stepExecution);
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        Logger stepLogger = this.getStepLogger();
        if (stepLogger.isInfoEnabled()) {
            stepLogger.info("afterStep ; {}", (Object)stepExecution);
        }
        return null;
    }

    public void afterRead(T item) {
        Logger readLogger = this.getReadLogger();
        if (readLogger.isInfoEnabled()) {
            readLogger.info("afterRead ; {}", item);
        }
    }

    public void beforeRead() {
        Logger readLogger = this.getReadLogger();
        if (readLogger.isInfoEnabled()) {
            readLogger.info("beforeRead");
        }
    }

    public void onReadError(Exception ex) {
        Logger readLogger = this.getReadLogger();
        if (readLogger.isInfoEnabled()) {
            readLogger.info("onReadError ; {}", (Throwable)ex);
        }
    }

    public void afterWrite(List<? extends S> items) {
        Logger writeLogger = this.getWriteLogger();
        if (writeLogger.isInfoEnabled()) {
            writeLogger.info("afterWrite ; {}", items);
        }
    }

    public void beforeWrite(List<? extends S> items) {
        Logger writeLogger = this.getWriteLogger();
        if (writeLogger.isInfoEnabled()) {
            writeLogger.info("beforeWrite ; {}", items);
        }
    }

    public void onWriteError(Exception exception, List<? extends S> items) {
        Logger writeLogger = this.getWriteLogger();
        if (writeLogger.isInfoEnabled()) {
            writeLogger.info("onWriteError ; {} ; {}", items, (Object)exception);
        }
    }

    public void afterProcess(T item, S result) {
        Logger processLogger = this.getProcessLogger();
        if (processLogger.isInfoEnabled()) {
            processLogger.info("afterProcess ; {} ; {}", item, result);
        }
    }

    public void beforeProcess(T item) {
        Logger processLogger = this.getProcessLogger();
        if (processLogger.isInfoEnabled()) {
            processLogger.info("beforeProcess ; {}", item);
        }
    }

    public void onProcessError(T item, Exception e) {
        Logger processLogger = this.getProcessLogger();
        if (processLogger.isWarnEnabled()) {
            processLogger.warn("onProcessError ; {} ; {}", item, (Object)e);
        }
    }

    public void onSkipInProcess(T item, Throwable t) {
        Logger processLogger = this.getProcessLogger();
        if (processLogger.isWarnEnabled()) {
            processLogger.warn("onSkipInProcess ; {} ; {}", item, (Object)t);
        }
    }

    public void onSkipInRead(Throwable t) {
        Logger readLogger = this.getReadLogger();
        if (readLogger.isWarnEnabled()) {
            readLogger.warn("onSkipInRead ; {}", t);
        }
    }

    public void onSkipInWrite(S item, Throwable t) {
        Logger writeLogger = this.getWriteLogger();
        if (writeLogger.isWarnEnabled()) {
            writeLogger.warn("onSkipInWrite ; {} ; {}", item, (Object)t);
        }
    }

    public void beforeChunk(ChunkContext context) {
        Logger chunkLogger = this.getChunkLogger();
        if (chunkLogger.isInfoEnabled()) {
            chunkLogger.info("beforeChunk");
        }
    }

    public void afterChunk(ChunkContext context) {
        Logger chunkLogger = this.getChunkLogger();
        if (chunkLogger.isInfoEnabled()) {
            chunkLogger.info("afterChunk");
        }
    }

    public void afterChunkError(ChunkContext context) {
        Logger chunkLogger = this.getChunkLogger();
        if (chunkLogger.isInfoEnabled()) {
            chunkLogger.info("afterChunkError");
        }
    }
}

