/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.listener;

import javax.sql.DataSource;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class ExecuteSQLPostStepExecutionListener
implements StepExecutionListener,
InitializingBean {
    private DataSource dataSource;
    private String[] sqls;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"A transaction manager must be provided");
        Assert.state((this.sqls != null ? 1 : 0) != 0, (String)"A transaction manager must be provided");
    }

    public void beforeStep(StepExecution stepExecution) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        for (String sql : this.sqls) {
            new JdbcTemplate(this.dataSource).execute(sql);
        }
        return ExitStatus.COMPLETED;
    }

    public void setDataSource(DataSource pDataSource) {
        this.dataSource = pDataSource;
    }

    public void setSqls(String ... sqls) {
        this.sqls = sqls;
    }
}

