/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.listener;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingExecutionListener {
    private Map<String, String> loggerNames = new HashMap<String, String>();
    private final Map<String, Logger> loggers = new HashMap<String, Logger>();
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public AbstractLoggingExecutionListener() {
        String loggerPrefix = this.getClass().getName() + '.' + this.getClass().getSimpleName();
        this.setLoggerName("job", loggerPrefix + "#job");
        this.setLoggerName("step", loggerPrefix + "#step");
        this.setLoggerName("chunk", loggerPrefix + "#chunk");
        this.setLoggerName("read", loggerPrefix + "#read");
        this.setLoggerName("process", loggerPrefix + "#process");
        this.setLoggerName("write", loggerPrefix + "#write");
    }

    private void setLoggerName(String phase, String loggerName) {
        this.loggerNames.put(phase, loggerName);
    }

    protected Logger getJobLogger() {
        return this.getLogger("job");
    }

    protected Logger getStepLogger() {
        return this.getLogger("step");
    }

    protected Logger getChunkLogger() {
        return this.getLogger("chunk");
    }

    protected Logger getReadLogger() {
        return this.getLogger("read");
    }

    protected Logger getProcessLogger() {
        return this.getLogger("process");
    }

    protected Logger getWriteLogger() {
        return this.getLogger("write");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Logger getLogger(String phase) {
        Logger logger = this.loggers.get(phase);
        if (logger == null) {
            String string = phase;
            synchronized (string) {
                logger = this.loggers.get(phase);
                if (logger == null) {
                    String loggerName = this.loggerNames.get(phase);
                    if (loggerName == null) {
                        loggerName = this.getClass().getName() + '.' + this.getClass().getSimpleName() + '#' + phase;
                        this.LOGGER.warn("No 'loggerName' found for phase '{}' ; using default : {}", (Object)phase, (Object)loggerName);
                    }
                    logger = LoggerFactory.getLogger((String)loggerName);
                    this.loggers.put(phase, logger);
                }
            }
        }
        return logger;
    }

    public void setLoggerNames(Map<String, String> loggerNames) {
        this.loggerNames = loggerNames;
    }
}

