/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.launcher;

import java.util.Set;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CustomJobLauncher
extends SimpleJobLauncher
implements InitializingBean {
    private JobExecutionDao jobExecutionDao;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobExecutionDao);
        super.afterPropertiesSet();
    }

    public JobExecution run(Job pJob, JobParameters pJobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder(pJobParameters);
        if (pJob.isRestartable()) {
            Set jobExecutions = this.jobExecutionDao.findRunningJobExecutions(pJob.getName());
            if (jobExecutions.isEmpty()) {
                jobParametersBuilder.addLong("time", Long.valueOf(System.currentTimeMillis()));
            } else {
                throw new JobExecutionAlreadyRunningException("A '" + pJob.getName() + "' job is already running");
            }
        }
        return super.run(pJob, jobParametersBuilder.toJobParameters());
    }

    public JobExecutionDao getJobExecutionDao() {
        return this.jobExecutionDao;
    }

    public void setJobExecutionDao(JobExecutionDao jobExecutionDao) {
        this.jobExecutionDao = jobExecutionDao;
    }
}

