/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.aggregator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class JaxbLineAggregator<T>
implements LineAggregator<T>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxbLineAggregator.class);
    private MessageBodyWriter<T> provider;
    private MediaType outputFormat;
    private Class<?> classToBeBound;
    private String encoding;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.provider);
        Assert.notNull((Object)this.outputFormat);
        Assert.notNull(this.classToBeBound);
    }

    public String aggregate(T item) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.provider.writeTo(item, this.classToBeBound, null, null, this.outputFormat, null, (OutputStream)baos);
            return this.encoding == null ? baos.toString() : baos.toString(this.encoding);
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public MessageBodyWriter<T> getProvider() {
        return this.provider;
    }

    public void setProvider(MessageBodyWriter<T> provider) {
        this.provider = provider;
    }

    public void setOutputFormat(String ouputFormat) {
        try {
            this.outputFormat = MediaType.valueOf((String)ouputFormat);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(String.format("Unable to create JaxbLineAggregator with outpout format{}", this.outputFormat), (Throwable)e);
            throw e;
        }
    }

    public void setClassToBeBound(Class<?> classesToBeBound) {
        this.classToBeBound = classesToBeBound;
    }

    public Class<?> getClassToBeBound() {
        return this.classToBeBound;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

