/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.spring.batch.core;

import io.sovaj.basics.spring.batch.core.JobExecutionDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

public class JdbcJobExecutionDAO
extends JdbcJobExecutionDao
implements JobExecutionDao {
    private static final String GET_EXECUTIONS = "SELECT E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, E.JOB_INSTANCE_ID, E.JOB_CONFIGURATION_LOCATION, I.JOB_NAME from %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID order by E.JOB_EXECUTION_ID desc limit ?, ?";
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_EXECUTION_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL, IDENTIFYING from %PREFIX%JOB_EXECUTION_PARAMS where JOB_EXECUTION_ID = ?";

    @Override
    public Collection<JobExecution> getJobInstances(int page, int size) {
        int from = (page - 1) * size;
        int to = page * size;
        final HashSet<JobExecution> result = new HashSet<JobExecution>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobExecutionRowMapper mapper = new JobExecutionRowMapper();
                result.add(mapper.mapRow(rs, 0));
            }
        };
        this.getJdbcTemplate().query(this.getQuery(GET_EXECUTIONS), new Object[]{from, to}, handler);
        return result;
    }

    protected JobParameters getJobParameters(Long executionId) {
        final HashMap map = new HashMap();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobParameter.ParameterType type = JobParameter.ParameterType.valueOf((String)rs.getString(3));
                JobParameter value = null;
                if (type == JobParameter.ParameterType.STRING) {
                    value = new JobParameter(rs.getString(4), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.LONG) {
                    value = new JobParameter(Long.valueOf(rs.getLong(6)), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.DOUBLE) {
                    value = new JobParameter(Double.valueOf(rs.getDouble(7)), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.DATE) {
                    value = new JobParameter((Date)rs.getTimestamp(5), rs.getString(8).equalsIgnoreCase("Y"));
                }
                map.put(rs.getString(2), value);
            }
        };
        this.getJdbcTemplate().query(this.getQuery(FIND_PARAMS_FROM_ID), new Object[]{executionId}, handler);
        return new JobParameters(map);
    }

    private final class JobExecutionRowMapper
    implements ParameterizedRowMapper<JobExecution> {
        private JobInstance jobInstance;
        private JobParameters jobParameters;

        public JobExecutionRowMapper() {
        }

        public JobExecutionRowMapper(JobInstance jobInstance) {
            this.jobInstance = jobInstance;
        }

        public JobExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong(1);
            String jobConfigurationLocation = rs.getString(10);
            String jobName = rs.getString(12);
            if (this.jobParameters == null) {
                this.jobParameters = JdbcJobExecutionDAO.this.getJobParameters(id);
            }
            JobExecution jobExecution = this.jobInstance == null ? new JobExecution(new JobInstance(null, jobName), id, this.jobParameters, jobConfigurationLocation) : new JobExecution(this.jobInstance, id, this.jobParameters, jobConfigurationLocation);
            jobExecution.setStartTime((Date)rs.getTimestamp(2));
            jobExecution.setEndTime((Date)rs.getTimestamp(3));
            jobExecution.setStatus(BatchStatus.valueOf((String)rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus(rs.getString(5), rs.getString(6)));
            jobExecution.setCreateTime((Date)rs.getTimestamp(7));
            jobExecution.setLastUpdated((Date)rs.getTimestamp(8));
            jobExecution.setVersion(Integer.valueOf(rs.getInt(9)));
            return jobExecution;
        }
    }
}

