/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.mongo;

import io.sovaj.basics.mongo.MongoDAO;
import io.sovaj.basics.mongo.domain.BusinessObject;
import io.sovaj.basics.mongo.domain.BusinessObjectHistorized;
import io.sovaj.basics.mongo.domain.VersionedBusinessObject;

public abstract class VersionedMongoDAO<T extends VersionedBusinessObject>
extends MongoDAO<T> {
    public String getVersionedCollection() {
        return this.getCollection() + ".history";
    }

    @Override
    public void create(T p) {
        ((VersionedBusinessObject)p).setVersion(1L);
        super.create(p);
    }

    @Override
    public void update(T p) {
        VersionedBusinessObject oldVersion = (VersionedBusinessObject)this.getById(((BusinessObject)p).getId());
        ((BusinessObject)p).setId(oldVersion.getId());
        ((VersionedBusinessObject)p).setVersion(oldVersion.getVersion() + 1L);
        super.update(p);
        this.mongoOps.save(new BusinessObjectHistorized<VersionedBusinessObject>(oldVersion), this.getVersionedCollection());
    }
}

