/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.mongo;

import com.mongodb.WriteResult;
import io.sovaj.basics.mongo.domain.BusinessObject;
import io.sovaj.basics.mongo.domain.PerMonthStatistic;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class MongoDAO<T extends BusinessObject> {
    @Autowired
    protected MongoOperations mongoOps;

    public abstract String getCollection();

    public abstract Class<T> getClazz();

    public void create(T pObject) {
        ((BusinessObject)pObject).setCreationDate(new Date());
        ((BusinessObject)pObject).setUpdatedDate(new Date());
        this.mongoOps.insert(pObject, this.getCollection());
    }

    public T getById(String pObjectId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)pObjectId));
        return (T)((BusinessObject)this.mongoOps.findOne(query, this.getClazz(), this.getCollection()));
    }

    public void update(T pObject) {
        ((BusinessObject)pObject).setUpdatedDate(new Date());
        this.mongoOps.save(pObject, this.getCollection());
    }

    public int delete(String pObjectId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)pObjectId));
        WriteResult result = this.mongoOps.remove(query, this.getClazz(), this.getCollection());
        return result.getN();
    }

    public T getByFieldName(String pFieldName, String pFieldValue) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)pFieldName).is((Object)pFieldValue));
        return (T)((BusinessObject)this.mongoOps.findOne(query, this.getClazz(), this.getCollection()));
    }

    public List<T> findByFieldName(String pFieldName, String pFieldValue) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)pFieldName).regex(pFieldValue, "i"));
        return this.mongoOps.find(query, this.getClazz(), this.getCollection());
    }

    public List<T> list() {
        return this.mongoOps.findAll(this.getClazz(), this.getCollection());
    }

    public List<PerMonthStatistic> countPerMonthSince(String dateFieldName, Date since) {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)dateFieldName).gt((Object)since)), Aggregation.project((String[])new String[]{"total"}).andExpression("month('" + dateFieldName + "')", new Object[0]).as("month").andExpression("year('" + dateFieldName + "')", new Object[0]).as("year"), Aggregation.group((Fields)Fields.fields((String[])new String[]{"month"}).and("year")).count().as("total")});
        return this.mongoOps.aggregate(agg, this.getCollection(), PerMonthStatistic.class).getMappedResults();
    }
}

