/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.logback.web;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.log4j.XMLLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.read.CyclicBufferAppender;
import io.sovaj.basics.logback.layout.json.JSONLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackServlet
extends HttpServlet {
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String logger = request.getParameter("logger");
        if (logger == null) {
            logger = "ROOT";
        }
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        LoggerContext loggerContext = (LoggerContext)loggerFactory;
        Logger theLogger = loggerContext.getLogger(logger);
        String cyclicBufferAppenderName = request.getParameter("cyclicBufferAppenderName");
        if (cyclicBufferAppenderName == null) {
            cyclicBufferAppenderName = "BUFFER";
        }
        CyclicBufferAppender bufferAppender = (CyclicBufferAppender)theLogger.getAppender(cyclicBufferAppenderName);
        bufferAppender.reset();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            CyclicBufferAppender bufferAppender;
            String logger = request.getParameter("logger");
            if (logger == null) {
                logger = "ROOT";
            }
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            LoggerContext loggerContext = (LoggerContext)loggerFactory;
            Logger theLogger = loggerContext.getLogger(logger);
            String cyclicBufferAppenderName = request.getParameter("cyclicBufferAppenderName");
            if (cyclicBufferAppenderName == null) {
                cyclicBufferAppenderName = "BUFFER";
            }
            if ((bufferAppender = (CyclicBufferAppender)theLogger.getAppender(cyclicBufferAppenderName)) == null) {
                throw new ServletException("No CyclicBufferAppender named '" + cyclicBufferAppenderName + "' found in logger '" + logger + "'");
            }
            CyclicBuffer buffer = (CyclicBuffer)FieldUtils.readField((Object)bufferAppender, (String)"cb", (boolean)true);
            String acceptedFormat = request.getHeader("Accept");
            if (acceptedFormat.contains("application/json")) {
                this.generateJSONOutput(response, loggerContext, (CyclicBuffer<ILoggingEvent>)buffer);
            } else if (acceptedFormat.contains("application/xhtml") || acceptedFormat.contains("application/html")) {
                this.generateHTMLOutput(response, loggerContext, (CyclicBuffer<ILoggingEvent>)buffer);
            } else {
                this.generateXMLOutput(response, loggerContext, (CyclicBuffer<ILoggingEvent>)buffer);
            }
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Erreur lors de la r\ufffdcup\ufffdration des logs", (Throwable)e);
        }
    }

    private void generateHTMLOutput(HttpServletResponse response, LoggerContext loggerContext, CyclicBuffer<ILoggingEvent> buffer) throws IOException {
        response.setContentType("text/html");
        response.setHeader("Cache-control", "no-cache");
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        HTMLLayout layout = new HTMLLayout();
        layout.setPattern("%date%level%logger%msg");
        layout.setContext((Context)loggerContext);
        layout.start();
        encoder.setLayout((Layout)layout);
        encoder.setContext((Context)loggerContext);
        encoder.start();
        OutputStreamAppender osAppender = new OutputStreamAppender();
        osAppender.setContext((Context)loggerContext);
        osAppender.setEncoder((Encoder)encoder);
        ServletOutputStream os = response.getOutputStream();
        osAppender.setOutputStream((OutputStream)os);
        osAppender.start();
        List events = buffer.asList();
        for (ILoggingEvent event : events) {
            osAppender.doAppend((Object)event);
        }
        osAppender.stop();
        encoder.stop();
        layout.stop();
        os.flush();
    }

    private void generateJSONOutput(HttpServletResponse response, LoggerContext loggerContext, CyclicBuffer<ILoggingEvent> buffer) throws IOException {
        response.setContentType("application/json");
        response.setHeader("Cache-control", "no-cache");
        JSONLayout layout = new JSONLayout();
        layout.setContext((Context)loggerContext);
        layout.setPattern("%date%level%logger%msg");
        layout.start();
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setLayout((Layout)layout);
        encoder.setContext((Context)loggerContext);
        encoder.start();
        OutputStreamAppender osAppender = new OutputStreamAppender();
        osAppender.setContext((Context)loggerContext);
        osAppender.setEncoder((Encoder)encoder);
        ServletOutputStream os = response.getOutputStream();
        osAppender.setOutputStream((OutputStream)os);
        osAppender.start();
        List events = buffer.asList();
        for (ILoggingEvent event : events) {
            osAppender.doAppend((Object)event);
        }
        osAppender.stop();
        encoder.stop();
        layout.stop();
        os.flush();
    }

    private void generateXMLOutput(HttpServletResponse response, LoggerContext loggerContext, CyclicBuffer<ILoggingEvent> buffer) throws IOException {
        response.setContentType("application/json");
        response.setHeader("Cache-control", "no-cache");
        XMLLayout layout = new XMLLayout();
        layout.setContext((Context)loggerContext);
        layout.start();
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setLayout((Layout)layout);
        encoder.setContext((Context)loggerContext);
        encoder.start();
        OutputStreamAppender osAppender = new OutputStreamAppender();
        osAppender.setContext((Context)loggerContext);
        osAppender.setEncoder((Encoder)encoder);
        ServletOutputStream os = response.getOutputStream();
        osAppender.setOutputStream((OutputStream)os);
        osAppender.start();
        List events = buffer.asList();
        for (ILoggingEvent event : events) {
            osAppender.doAppend((Object)event);
        }
        osAppender.stop();
        encoder.stop();
        layout.stop();
        os.flush();
    }
}

