/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.logback.web;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class ConfigLogbackServlet
extends HttpServlet {
    final Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
    final LoggerContext loggerRepository = this.rootLogger.getLoggerContext();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List loggers = this.loggerRepository.getLoggerList();
        PrintWriter responseWriter = response.getWriter();
        String prefix = "";
        responseWriter.append("[");
        for (Logger logger : loggers) {
            responseWriter.append(prefix);
            prefix = ",";
            responseWriter.append("{\"Name\" : \"");
            responseWriter.append(logger.getName());
            responseWriter.append("\", \"Level\" : \"");
            responseWriter.append(logger.getLevel() != null ? logger.getLevel().toString() : logger.getEffectiveLevel().toString());
            responseWriter.append("\"}");
        }
        responseWriter.append("]");
        response.getWriter().flush();
        response.getWriter().close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String newRootLevel = request.getParameter("rootLoggingLevel");
        if (StringUtils.isNotBlank((String)newRootLevel)) {
            Level newLevel = Level.toLevel((String)newRootLevel);
            this.rootLogger.setLevel(newLevel);
        }
        String loggerName = request.getParameter("loggerName");
        String loggerLevel = request.getParameter("loggerLevel");
        if (StringUtils.isNotBlank((String)loggerName) && StringUtils.isNotBlank((String)loggerLevel)) {
            Level level = Level.toLevel((String)loggerLevel);
            this.loggerRepository.getLogger(loggerName).setLevel(level);
        }
        response.getOutputStream().flush();
    }
}

