/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.logback.layout.json;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.Map;

public abstract class JSONLayoutBase<E>
extends LayoutBase<E> {
    protected String pattern;
    protected Converter<E> head;

    public void setPattern(String conversionPattern) {
        this.pattern = conversionPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void start() {
        int errorCount = 0;
        try {
            Parser p = new Parser(this.pattern);
            p.setContext(this.getContext());
            Node t = p.parse();
            this.head = p.compile(t, this.getEffectiveConverterMap());
            ConverterUtil.startConverters(this.head);
        }
        catch (ScanException ex) {
            this.addError("Incorrect pattern found", ex);
            ++errorCount;
        }
        if (errorCount == 0) {
            this.started = true;
        }
    }

    protected abstract Map<String, String> getDefaultConverterMap();

    public Map<String, String> getEffectiveConverterMap() {
        Map contextMap;
        Context lContext;
        HashMap<String, String> effectiveMap = new HashMap<String, String>();
        Map<String, String> defaultMap = this.getDefaultConverterMap();
        if (defaultMap != null) {
            effectiveMap.putAll(defaultMap);
        }
        if ((lContext = this.getContext()) != null && (contextMap = (Map)lContext.getObject("PATTERN_RULE_REGISTRY")) != null) {
            effectiveMap.putAll(contextMap);
        }
        return effectiveMap;
    }

    public String getContentType() {
        return "application/json";
    }

    public String getFileHeader() {
        return "";
    }

    public String getPresentationHeader() {
        return "[";
    }

    public String getPresentationFooter() {
        return "]";
    }

    public String getFileFooter() {
        return "";
    }

    protected String computeConverterName(Converter c) {
        String className = c.getClass().getSimpleName();
        int index = className.indexOf("Converter");
        if (index == -1) {
            return className;
        }
        return className.substring(0, index);
    }
}

