/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.logback.layout.json;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.pattern.Converter;
import io.sovaj.basics.logback.layout.json.JSONLayoutBase;
import io.sovaj.basics.logback.layout.json.MessageConverter;
import java.util.HashMap;
import java.util.Map;

public class JSONLayout
extends JSONLayoutBase<ILoggingEvent> {
    public static final Map<String, String> converterMap = new HashMap<String, String>(PatternLayout.defaultConverterMap);
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;
    private String prefixList = "";

    public JSONLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
    }

    @Override
    public void start() {
        int errorCount = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++errorCount;
        }
        if (errorCount == 0) {
            super.start();
        }
    }

    @Override
    protected Map<String, String> getDefaultConverterMap() {
        return converterMap;
    }

    public String doLayout(ILoggingEvent event) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.prefixList);
        this.prefixList = ",";
        buf.append("{");
        String prefix = "";
        for (Converter c = this.head; c != null; c = c.getNext()) {
            buf.append(prefix);
            prefix = ",";
            buf.append("\"");
            buf.append(this.computeConverterName(c));
            buf.append("\" : \"");
            c.write(buf, (Object)event);
            buf.append("\"");
        }
        buf.append("}");
        if (event.getThrowableProxy() != null) {
            this.throwableRenderer.render(buf, (Object)event);
        }
        return buf.toString();
    }

    public IThrowableRenderer getThrowableRenderer() {
        return this.throwableRenderer;
    }

    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> throwableRenderer) {
        this.throwableRenderer = throwableRenderer;
    }

    @Override
    protected String computeConverterName(Converter c) {
        if (c instanceof MDCConverter) {
            MDCConverter mc = (MDCConverter)c;
            String key = mc.getFirstOption();
            if (key != null) {
                return key;
            }
            return "MDC";
        }
        return super.computeConverterName(c);
    }

    static {
        converterMap.put("m", MessageConverter.class.getName());
        converterMap.put("msg", MessageConverter.class.getName());
        converterMap.put("message", MessageConverter.class.getName());
    }
}

