/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.core.utlis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ZipperUtil {
    public static final String CHARACTER_ENCODING_UTF_8 = "UTF-8";

    public static byte[] zip(String payload) throws UnsupportedEncodingException, IOException {
        byte[] data = payload.getBytes(CHARACTER_ENCODING_UTF_8);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Deflater d = new Deflater();
        try (DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)output, d);){
            dout.write(data);
        }
        return output.toByteArray();
    }

    public static String unZip(byte[] input) throws UnsupportedEncodingException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        InflaterInputStream in = new InflaterInputStream(inputStream);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = in.read(buffer)) > 0) {
            bout.write(buffer, 0, len);
        }
        in.close();
        bout.close();
        return bout.toString(CHARACTER_ENCODING_UTF_8);
    }
}

