/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.core.utlis;

import io.sovaj.basics.core.utlis.ITimeSource;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class SystemTime {
    private static final ITimeSource DEFAULT_SRC = new ITimeSource(){

        @Override
        public long millis() {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            Calendar cal = Calendar.getInstance(TimeZone.getDefault());
            return cal.getTimeInMillis();
        }
    };
    private static ITimeSource source = null;

    private SystemTime() {
    }

    public static long asMillis() {
        return SystemTime.getTimeSource().millis();
    }

    public static Date asDate() {
        return new Date(SystemTime.asMillis());
    }

    public static void reset() {
        SystemTime.setTimeSource(null);
    }

    public static void setTimeSource(ITimeSource source) {
        SystemTime.source = source;
    }

    private static ITimeSource getTimeSource() {
        return source != null ? source : DEFAULT_SRC;
    }
}

