/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.core.utlis;

import java.util.BitSet;
import java.util.Formatter;

public class EncodingUtils {
    protected static final BitSet ASCII_QUERY_CHARS;
    protected static final BitSet RESTRICTED_CHARS;
    protected static final char[] UNRESERVE_CHARS;
    protected static final String PUNCT_STRING = ",;:$&+=";
    protected static final char[] PUNCT_CHARS;
    protected static final String RESERVED_STRING = "?/[]@\\";
    protected static final char[] RESERVED_CHARS;

    public static String getRestrictedChars() {
        return ",;:$&+=?/[]@\\";
    }

    public static boolean containsURLSpecificCharacter(CharSequence in) {
        if (in == null) {
            return false;
        }
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = false;
            if (c < '\u0080') {
                if (RESTRICTED_CHARS.get(c)) {
                    escape = true;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = true;
            }
            if (!escape) continue;
            return true;
        }
        return false;
    }

    public static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (ASCII_QUERY_CHARS.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf != null) continue;
            outBuf = new StringBuilder(in.length() + 15);
            ((StringBuilder)outBuf).append(in, 0, i);
            Formatter formatter = new Formatter((Appendable)((Object)outBuf));
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        UNRESERVE_CHARS = "_-!.~'()*".toCharArray();
        PUNCT_CHARS = PUNCT_STRING.toCharArray();
        RESERVED_CHARS = RESERVED_STRING.toCharArray();
        ASCII_QUERY_CHARS = new BitSet(128);
        RESTRICTED_CHARS = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ASCII_QUERY_CHARS.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ASCII_QUERY_CHARS.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ASCII_QUERY_CHARS.set(c);
        }
        for (char c2 : UNRESERVE_CHARS) {
            ASCII_QUERY_CHARS.set(c2);
        }
        for (char c2 : PUNCT_CHARS) {
            ASCII_QUERY_CHARS.set(c2);
            RESTRICTED_CHARS.set(c2);
        }
        for (char c2 : RESERVED_CHARS) {
            ASCII_QUERY_CHARS.set(c2);
            RESTRICTED_CHARS.set(c2);
        }
        ASCII_QUERY_CHARS.set(37);
        RESTRICTED_CHARS.set(37);
        RESTRICTED_CHARS.set(92);
        RESTRICTED_CHARS.set(9);
        RESTRICTED_CHARS.set(32);
    }
}

