/*
 * Decompiled with CFR 0.152.
 */
package io.sovaj.basics.amazonws.client.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import io.sovaj.basics.amazonws.client.AmazonS3Content;
import io.sovaj.basics.amazonws.client.AmazonWSException;
import io.sovaj.basics.amazonws.client.IAmazonWSClient;
import io.sovaj.basics.amazonws.client.impl.AmazonWsConfig;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonWSClient
implements IAmazonWSClient {
    public static final String URL_SUB_DIRECTORY_SEPARATOR = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonWSClient.class);
    private final ClientConfiguration clientConfig;
    private final AWSCredentials credentials;
    private final AmazonS3 conn;
    private final String s3Bucket;
    private final String S3AmazonawsComWebUrl;

    public AmazonWSClient(AmazonWsConfig wsConfig) {
        this.credentials = new BasicAWSCredentials(wsConfig.getAccessKey(), wsConfig.getSecretKey());
        this.s3Bucket = wsConfig.getS3Bucket();
        this.clientConfig = new ClientConfiguration();
        this.S3AmazonawsComWebUrl = wsConfig.getS3AmazonawsComWebUrl();
        this.clientConfig.setProtocol(Protocol.HTTPS);
        this.conn = new AmazonS3Client(this.credentials, this.clientConfig);
    }

    private String buildUrl(String subDirectory, String contentLabel) {
        StringBuilder urlSb = new StringBuilder(this.S3AmazonawsComWebUrl);
        if (!StringUtils.startsWith((String)subDirectory, (String)URL_SUB_DIRECTORY_SEPARATOR)) {
            urlSb.append('/');
        }
        urlSb.append(subDirectory);
        if (!StringUtils.endsWith((String)subDirectory, (String)URL_SUB_DIRECTORY_SEPARATOR)) {
            urlSb.append('/');
        }
        if (StringUtils.startsWith((String)contentLabel, (String)URL_SUB_DIRECTORY_SEPARATOR)) {
            urlSb.append(contentLabel.substring(1));
        } else {
            urlSb.append(contentLabel);
        }
        return urlSb.toString();
    }

    private String buildUrl(String key) {
        String url = this.S3AmazonawsComWebUrl;
        if (!StringUtils.startsWith((String)key, (String)URL_SUB_DIRECTORY_SEPARATOR)) {
            url = url + '/';
        }
        return url + key;
    }

    private boolean validateContent(AmazonS3Content content) {
        if (StringUtils.isBlank((String)content.getSubDirectory())) {
            return false;
        }
        if (StringUtils.isBlank((String)content.getMimeType())) {
            return false;
        }
        if (content.getContent() == null) {
            return false;
        }
        return !StringUtils.isBlank((String)content.getContentLabel());
    }

    @Override
    public String deploy(String contentType, InputStream contentStream, String destKey) throws AmazonWSException {
        AmazonS3Content content = new AmazonS3Content(this.s3Bucket, contentType, contentStream, destKey);
        LOGGER.trace("Deploying Content: {}", (Object)ToStringBuilder.reflectionToString((Object)content, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        if (!this.validateContent(content)) {
            throw new AmazonWSException("Invalid content");
        }
        AmazonS3Client conn = new AmazonS3Client(this.credentials, this.clientConfig);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(content.getMimeType());
        try {
            PutObjectResult result = conn.putObject(content.getSubDirectory(), content.getContentLabel(), content.getContent(), metadata);
            if (result != null) {
                return this.buildUrl(content.getSubDirectory(), content.getContentLabel());
            }
            return null;
        }
        catch (Exception e) {
            throw new AmazonWSException(e.getMessage(), e);
        }
    }

    @Override
    public void copy(String srcKey, String destKey) throws AmazonWSException {
        try {
            CopyObjectResult copyObjectResult = this.conn.copyObject(new CopyObjectRequest(this.s3Bucket, srcKey, this.s3Bucket, destKey));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not copy from key '" + srcKey + "' to key '" + destKey + "'", (Throwable)ex);
            throw new AmazonWSException(ex.getMessage(), ex);
        }
    }

    @Override
    public String move(String srcKey, String destKey) throws AmazonWSException {
        try {
            this.copy(srcKey, destKey);
        }
        catch (AmazonWSException ex) {
            LOGGER.warn("Move failed at copy from key '" + srcKey + "' to key '" + destKey + "'");
            throw ex;
        }
        try {
            this.delete(srcKey);
        }
        catch (AmazonWSException ex) {
            LOGGER.warn("Move failed at delete key '" + srcKey + "'");
            throw ex;
        }
        return this.buildUrl(destKey);
    }

    @Override
    public void delete(String srcKey) throws AmazonWSException {
        try {
            this.conn.deleteObject(new DeleteObjectRequest(this.s3Bucket, srcKey));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not delete key '" + srcKey + "'", (Throwable)ex);
            throw new AmazonWSException(ex.getMessage(), ex);
        }
    }

    @Override
    public InputStream read(String srcKey) throws AmazonWSException {
        try {
            S3Object object = this.conn.getObject(new GetObjectRequest(this.s3Bucket, srcKey));
            return object.getObjectContent();
        }
        catch (Exception ex) {
            LOGGER.warn("Could not get stream for S3 object with key '" + srcKey + "'", (Throwable)ex);
            return null;
        }
    }
}

