/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.populate;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="data", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class DataMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/src/deb/data")
    private File dataSourceDir;
    @Parameter(defaultValue="${project.basedir}/src/deb/control")
    private File controlSourceDir;
    @Parameter(defaultValue="${project.build.directory}/deb")
    private File stageDir;
    @Parameter(defaultValue="${project.build.directory}/control")
    private File controlDir;

    public void copyDirectory(File source, File destination) throws IOException {
        final Path src = source.toPath();
        final Path dst = destination.toPath();
        if (!Files.isDirectory(src, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(dst, new FileAttribute[0]);
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path target = dst.resolve(src.relativize(dir));
                if (Files.isDirectory(target, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                Files.copy(dir, target, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path target = dst.resolve(src.relativize(file));
                if (Files.exists(target, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                Files.copy(file, target, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void execute() throws MojoExecutionException {
        try {
            this.copyDirectory(this.controlSourceDir, this.controlDir);
            this.copyDirectory(this.dataSourceDir, this.stageDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while coping directory", (Exception)e);
        }
    }
}

