/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.pack;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class PermissionModification {
    private static final Path ROOT = Paths.get(File.separator, new String[0]);
    private static final int TYPE_MASK = 61440;
    private static final Pattern PERMISSIONS_PATTERN = Pattern.compile("[0-7]{3}");
    private String permissions;
    private Set<String> include;
    private Set<String> exclude;

    public PermissionModification() {
    }

    public PermissionModification(String permissions, Set<String> include, Set<String> exclude) {
        this.permissions = permissions;
        this.include = new HashSet<String>(include);
        this.exclude = new HashSet<String>(exclude);
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public Set<String> getInclude() {
        if (this.include == null) {
            this.include = new HashSet<String>();
        }
        return this.include;
    }

    public Set<String> getExclude() {
        if (this.exclude == null) {
            this.exclude = new HashSet<String>();
        }
        return this.exclude;
    }

    public CompiledPermissions compile() {
        if (!PERMISSIONS_PATTERN.matcher(this.permissions.trim()).matches()) {
            throw new IllegalArgumentException("Please use octal permissions format, instead of '" + this.permissions + "'");
        }
        FileSystem fs = FileSystems.getDefault();
        return new CompiledPermissions(Integer.parseInt(this.permissions.trim(), 8), this.getInclude().stream().map(s -> fs.getPathMatcher("glob:" + s.trim())).collect(Collectors.toSet()), this.getExclude().stream().map(s -> fs.getPathMatcher("glob:" + s.trim())).collect(Collectors.toSet()));
    }

    public class CompiledPermissions {
        private int permissions;
        private Set<PathMatcher> include;
        private Set<PathMatcher> exclude;

        CompiledPermissions(int permissions, Set<PathMatcher> include, Set<PathMatcher> exclude) {
            this.permissions = permissions;
            this.include = Objects.requireNonNull(include);
            this.exclude = Objects.requireNonNull(exclude);
        }

        public boolean apply(TarArchiveEntry entry, Path path) {
            Path absPath = ROOT.resolve(path);
            if (!this.include.isEmpty()) {
                boolean included = false;
                for (PathMatcher inc : this.include) {
                    if (!inc.matches(absPath)) continue;
                    included = true;
                    break;
                }
                if (!included) {
                    return false;
                }
            }
            if (!this.exclude.isEmpty()) {
                for (PathMatcher ex : this.exclude) {
                    if (!ex.matches(absPath)) continue;
                    return false;
                }
            }
            entry.setMode(entry.getMode() & 0xF000 | this.permissions);
            return true;
        }
    }
}

