/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.man;

import io.solit.deb.man.ManPage;
import io.solit.deb.man.Section;
import io.solit.deb.man.parse.ManParseException;
import io.solit.deb.man.parse.MarkdownParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="man", defaultPhase=LifecyclePhase.COMPILE)
public class ManMojo
extends AbstractMojo {
    private static final Pattern MAN_FILE_PATTERN = Pattern.compile("(.+)\\.(\\d+)\\.md", 2);
    private static final Pattern MAN_DIRECTORY_PATTERN = Pattern.compile("man(\\d+)");
    @Parameter(defaultValue="${project.basedir}/src/deb/doc")
    private File manSourceDirectory;
    @Parameter
    private File manDestinationDirectory;
    @Parameter(defaultValue="true")
    private boolean deduceManTitle = true;
    @Parameter(defaultValue="false")
    private boolean strictManParsing = false;
    @Parameter
    private String manSource;
    @Parameter
    private String manName;
    @Parameter(property="deb.name", defaultValue="${project.artifactId}")
    private String packageName;
    @Parameter(defaultValue="${project.build.directory}/deb")
    private File stageDir;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Charset charset;
            if (this.sourceEncoding == null) {
                charset = Charset.defaultCharset();
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + charset.name() + " i.e. build is platform dependent!"));
            } else {
                charset = Charset.forName(this.sourceEncoding);
            }
            Path dest = this.manDestinationDirectory == null ? this.stageDir.toPath().resolve("usr").resolve("share").resolve("man") : this.manDestinationDirectory.toPath();
            MarkdownParser parser = new MarkdownParser().setSource(this.manSource == null ? this.packageName : this.manSource).setManual(this.manName == null ? this.packageName + " manual" : this.manName);
            Path source = this.manSourceDirectory.toPath();
            if (Files.isDirectory(source, new LinkOption[0])) {
                Files.walkFileTree(this.manSourceDirectory.toPath(), new MdVisitor(charset, parser, source, dest));
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof ManParseException) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private class MdVisitor
    extends SimpleFileVisitor<Path> {
        private final Charset charset;
        private final MarkdownParser parser;
        private final Path destination;
        private final Path source;

        public MdVisitor(Charset charset, MarkdownParser parser, Path source, Path destination) {
            this.charset = charset;
            this.parser = parser;
            this.source = source;
            this.destination = destination;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().toLowerCase().endsWith(".md")) {
                String destinationName;
                Path manFile;
                Path relative = this.source.relativize(file);
                Path parent = relative.getParent();
                Consumer<String> warningHandler = ManMojo.this.strictManParsing ? w -> {
                    throw new ManParseException((String)w);
                } : w -> ManMojo.this.getLog().warn((CharSequence)("File '" + file.toString() + "': " + w));
                ManPage page = this.readManPage(file, parent, warningHandler);
                this.validateManPage(page, warningHandler);
                if (parent == null) {
                    parent = Paths.get("man" + page.getManSection(), new String[0]);
                }
                if (Files.exists(manFile = (parent = this.destination.resolve(parent)).resolve(destinationName = page.getName() + "." + page.getManSection() + ".gz"), new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                Files.createDirectories(parent, new FileAttribute[0]);
                GzipParameters parameters = new GzipParameters();
                parameters.setCompressionLevel(9);
                try (FileOutputStream os = new FileOutputStream(manFile.toFile());
                     GzipCompressorOutputStream gz = new GzipCompressorOutputStream((OutputStream)os, parameters);
                     OutputStreamWriter wr = new OutputStreamWriter((OutputStream)gz, StandardCharsets.UTF_8);){
                    page.write(wr);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private ManPage readManPage(Path file, Path parent, Consumer<String> warningHandler) throws IOException {
            ManPage page;
            try (FileInputStream is = new FileInputStream(file.toFile());
                 InputStreamReader input = new InputStreamReader((InputStream)is, this.charset);){
                if (ManMojo.this.deduceManTitle) {
                    int section;
                    String title;
                    Matcher fn = MAN_FILE_PATTERN.matcher(file.getFileName().toString());
                    if (fn.matches()) {
                        title = fn.group(1);
                        section = Integer.parseInt(fn.group(2));
                    } else {
                        Matcher pd;
                        title = file.getFileName().toString();
                        title = title.substring(0, title.length() - 3);
                        section = parent != null ? ((pd = MAN_DIRECTORY_PATTERN.matcher(parent.getFileName().toString())).matches() ? Integer.parseInt(pd.group(1)) : 1) : 1;
                    }
                    String description = this.createDefaultDescription(title, section);
                    page = this.parser.parse(input, warningHandler, title, section, description);
                } else {
                    page = this.parser.parse(input, warningHandler);
                }
            }
            catch (ManParseException e) {
                throw new IOException("Markdown processing error: File: '" + file.toString() + "': " + e.getMessage(), e);
            }
            return page;
        }

        private String createDefaultDescription(String title, int section) {
            String description;
            switch (section) {
                default: {
                    description = title + " user command";
                    break;
                }
                case 2: {
                    description = title + " system call";
                    break;
                }
                case 3: {
                    description = title + " library";
                    break;
                }
                case 4: {
                    description = title + " special file";
                    break;
                }
                case 5: {
                    description = title + " file format";
                    break;
                }
                case 6: {
                    description = title + " game";
                    break;
                }
                case 7: {
                    description = title + " overview";
                    break;
                }
                case 8: {
                    description = title + " administrative utility";
                }
            }
            return description;
        }

        private void validateManPage(ManPage page, Consumer<String> warningHandler) {
            this.validateSections(page, warningHandler);
        }

        private void validateSections(ManPage page, Consumer<String> warningHandler) {
            LinkedHashSet<Integer> standard = new LinkedHashSet<Integer>();
            HashSet<String> nonStandard = new HashSet<String>();
            block36: for (Section s : page.getAdditionalSections()) {
                switch (s.getName().toUpperCase()) {
                    case "SYNOPSIS": {
                        if (standard.add(2)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "CONFIGURATION": {
                        if (standard.add(3)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "DESCRIPTION": {
                        if (standard.add(4)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "OPTIONS": {
                        if (standard.add(5)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "EXIT STATUS": {
                        if (standard.add(6)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "RETURN VALUE": {
                        if (standard.add(7)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "ERRORS": {
                        if (standard.add(8)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "ENVIRONMENT": {
                        if (standard.add(9)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "FILES": {
                        if (standard.add(10)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "VERSIONS": {
                        if (standard.add(11)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "ATTRIBUTES": {
                        if (standard.add(12)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "CONFORMING TO": {
                        if (standard.add(13)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "NOTES": {
                        if (standard.add(14)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "BUGS": {
                        if (standard.add(15)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "EXAMPLE": {
                        if (standard.add(16)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                    case "SEE ALSO": {
                        if (standard.add(17)) continue block36;
                        warningHandler.accept("Duplicate section name " + s.getName());
                        continue block36;
                    }
                }
                if (nonStandard.add(s.getName().toUpperCase())) continue;
                warningHandler.accept("Duplicate section name " + s.getName());
            }
            if (!standard.containsAll(Arrays.asList(2, 4, 17))) {
                warningHandler.accept("Not all recommended sections are present: [SYNOPSIS, DESCRIPTION, SEE ALSO]");
            }
            int last = 0;
            for (Integer i : standard) {
                if (i < last) {
                    warningHandler.accept("Standard sections should follow in recommended order");
                    break;
                }
                last = i;
            }
        }
    }
}

