/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.dependencies;

import io.solit.plugin.maven.deb.dependencies.DependenciesFilter;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public abstract class AbstractDependencyMojo<T>
extends AbstractMojo {
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(readonly=true, defaultValue="${session}")
    protected MavenSession session;
    @Parameter(readonly=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    private DependenciesFilter traverseExclusions;
    @Parameter
    private DependenciesFilter packageExclusions;
    @Parameter(property="deb.root", defaultValue="${project.build.directory}/deb")
    protected File stageDir;
    @Parameter(property="deb.name", defaultValue="${project.artifactId}")
    protected String packageName;
    @Parameter
    private File dependencyDir;
    @Component
    private ProjectBuilder projectBuilder;

    protected void traverseDependencies(T context) throws MojoExecutionException, MojoFailureException {
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            File dependencyDirectory = this.getDependencyDirectory();
            request.setProject(this.project);
            DependencyNode root = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, (ArtifactFilter)new AndArtifactFilter(Arrays.asList(new ScopeArtifactFilter("runtime"), artifact -> this.traverseExclusions == null || !this.traverseExclusions.exclude(artifact))));
            ArrayDeque<DependencyArtifact> front = new ArrayDeque<DependencyArtifact>(Collections.singletonList(new DependencyArtifact(root, this.project)));
            DependencyArtifact a = (DependencyArtifact)front.poll();
            while (a != null) {
                a.getChildren().forEach(front::push);
                if (this.packageExclusions == null || !this.packageExclusions.exclude(a.getArtifact())) {
                    this.processDependency(a, context, dependencyDirectory, a.node == root);
                }
                a = (DependencyArtifact)front.poll();
            }
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoFailureException("Unable to collect dependencies" + e.getMessage(), (Throwable)e);
        }
        catch (ProjectBuildingException e) {
            throw new MojoFailureException("Unable to build project" + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void processDependency(DependencyArtifact var1, T var2, File var3, boolean var4) throws MojoExecutionException;

    protected File getDependencyDirectory() throws MojoExecutionException {
        File dependencyDir = this.dependencyDir;
        if (dependencyDir == null) {
            if (this.packageName == null || this.stageDir == null) {
                throw new MojoExecutionException("No dependency dir specified");
            }
            dependencyDir = this.stageDir;
            for (String s : new String[]{"usr", "share", this.packageName}) {
                dependencyDir = new File(dependencyDir, s);
            }
        }
        return dependencyDir;
    }

    protected class DependencyArtifact {
        private final DependencyNode node;
        private final MavenProject project;

        public DependencyArtifact(DependencyNode node, MavenProject project) {
            this.node = node;
            this.project = project;
        }

        public Artifact getArtifact() {
            return this.node.getArtifact();
        }

        public MavenProject getProject() {
            return this.project;
        }

        List<DependencyArtifact> getChildren() throws ProjectBuildingException {
            ArrayList<DependencyArtifact> result = new ArrayList<DependencyArtifact>(this.node.getChildren().size());
            for (DependencyNode node : this.node.getChildren()) {
                ProjectBuildingRequest request = new DefaultProjectBuildingRequest().setLocalRepository(AbstractDependencyMojo.this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setRepositorySession(AbstractDependencyMojo.this.session.getRepositorySession()).setSystemProperties(AbstractDependencyMojo.this.session.getSystemProperties()).setProcessPlugins(false).setResolveDependencies(false).setValidationLevel(0);
                MavenProject project = AbstractDependencyMojo.this.projectBuilder.build(node.getArtifact(), request).getProject();
                result.add(new DependencyArtifact(node, project));
            }
            return result;
        }
    }
}

