/*
 * Decompiled with CFR 0.152.
 */
package io.solit.plugin.maven.deb.changelog;

import io.solit.deb.Version;
import io.solit.deb.changes.ChangeSet;
import io.solit.deb.changes.Changelog;
import io.solit.deb.changes.KeepChangelogParser;
import io.solit.deb.changes.StringChanges;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="changelog", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ChangelogMojo
extends AbstractMojo {
    private static final String SNAPSHOT = "-SNAPSHOT";
    public static final String DEBIAN_CHANGELOG = "changelog.Debian.gz";
    public static final String UPSTREAM_CHANGELOG = "changelog.gz";
    @Parameter
    private boolean copyOriginalChangelog = false;
    @Parameter
    private boolean convertToDebianChangelog = true;
    @Parameter
    private boolean appendCurrentVersionChangeSet = true;
    @Parameter(defaultValue="${project.basedir}/changelog.md")
    private File changelogSource;
    @Parameter(defaultValue="${project.basedir}/changelog.md")
    private File upstreamChangelogSource;
    @Parameter(property="deb.version", defaultValue="${project.version}")
    private String version;
    @Parameter(property="deb.revision")
    private String revision;
    @Parameter
    private File changelogDestinationDirectory;
    @Parameter(defaultValue="${project.build.directory}/deb")
    private File stageDir;
    @Parameter(property="deb.name", defaultValue="${project.artifactId}")
    private String packageName;
    @Parameter(property="deb.maintainer", defaultValue="${project.developers[0].name}")
    private String maintainer;
    @Parameter(property="deb.maintainer", defaultValue="${project.developers[0].email}")
    private String maintainerEmail;
    @Parameter(defaultValue="stable")
    private String targetDistribution = "stable";
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.changelogSource == null || !this.changelogSource.isFile()) {
            return;
        }
        Path destinationDirectory = this.changelogDestinationDirectory == null ? this.stageDir.toPath().resolve("usr").resolve("share").resolve("doc").resolve(this.packageName) : this.changelogDestinationDirectory.toPath();
        try {
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
            if (this.copyOriginalChangelog) {
                this.createUpstreamChangelog(destinationDirectory);
            }
            if (this.convertToDebianChangelog) {
                this.createDebianChangelog(destinationDirectory);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while creating changelog", (Exception)e);
        }
    }

    private void createUpstreamChangelog(Path destinationDirectory) throws IOException {
        Path changelogFile = destinationDirectory.resolve(UPSTREAM_CHANGELOG);
        if (Files.exists(changelogFile, new LinkOption[0])) {
            return;
        }
        GzipParameters gp = new GzipParameters();
        gp.setCompressionLevel(9);
        try (FileOutputStream os = new FileOutputStream(changelogFile.toFile());
             GzipCompressorOutputStream gos = new GzipCompressorOutputStream((OutputStream)os, gp);){
            Files.copy(this.changelogSource.toPath(), (OutputStream)gos);
        }
    }

    private void createDebianChangelog(Path destinationDirectory) throws MojoFailureException, IOException {
        Changelog changelog;
        Charset charset;
        Version unreleasedVersion = this.getUnreleasedVersion();
        Path changelogFile = destinationDirectory.resolve(this.copyOriginalChangelog || unreleasedVersion.getRevision() != null ? DEBIAN_CHANGELOG : UPSTREAM_CHANGELOG);
        if (Files.exists(changelogFile, new LinkOption[0])) {
            return;
        }
        if (this.maintainer == null || this.maintainerEmail == null) {
            throw new MojoFailureException("Maintainer and email should not be null");
        }
        if (this.sourceEncoding == null) {
            charset = Charset.defaultCharset();
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + charset.name() + " i.e. build is platform dependent!"));
        } else {
            charset = Charset.forName(this.sourceEncoding);
        }
        KeepChangelogParser parser = new KeepChangelogParser(this.packageName, this.maintainer, this.maintainerEmail);
        parser.setDefaultDistribution(this.targetDistribution);
        parser.setUnreleasedVersion(unreleasedVersion);
        try (FileInputStream is = new FileInputStream(this.changelogSource);
             InputStreamReader reader = new InputStreamReader((InputStream)is, charset);){
            changelog = parser.parse(reader);
        }
        if (changelog == null) {
            return;
        }
        if (unreleasedVersion != null) {
            this.createUnreleasedVersionChangeSet(unreleasedVersion, changelog);
        }
        GzipParameters gp = new GzipParameters();
        gp.setCompressionLevel(9);
        try (FileOutputStream os = new FileOutputStream(changelogFile.toFile());
             GzipCompressorOutputStream gos = new GzipCompressorOutputStream((OutputStream)os, gp);
             OutputStreamWriter wr = new OutputStreamWriter((OutputStream)gos, StandardCharsets.UTF_8);){
            changelog.write(wr);
        }
    }

    private Version getUnreleasedVersion() {
        if (!this.appendCurrentVersionChangeSet) {
            return null;
        }
        String version = this.version;
        String revision = this.revision;
        if (version.endsWith(SNAPSHOT)) {
            version = version.substring(0, version.length() - SNAPSHOT.length());
            version = version + "+b" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return new Version(version, revision);
    }

    private void createUnreleasedVersionChangeSet(Version version, Changelog changelog) {
        boolean currentPresent = changelog.getChanges().stream().anyMatch(c -> version.equals(c.getVersion()));
        if (currentPresent) {
            return;
        }
        changelog.addChangeSet(new ChangeSet(this.packageName, version, this.maintainer, this.maintainerEmail, StringChanges.YANKED).setDistribution(this.targetDistribution));
    }
}

